package com.packtpub.hibernatesearch.startup;

import org.hibernate.Session;
import org.hibernate.search.backend.impl.jms.AbstractJMSHibernateSearchController;

/**
 * W rodowisku klastrowym z backendem opartym o JMS, wzy podrzdne mog aktualizowa indeksy Lucene wysyajc dania
 * do kolejki JMS.  Wze nadrzdny jest odpowiedzialny za monitorwanie kolejki i przetwarzanie otrzymanych da.
 * 
 * Aby wykona aktualizacje indeksu wze nadrzeny powiniem uy klasy dziedziczcej po pochodzcej z Hibernate Search 
 * abstrakcyjnej klasie "AbstractJMSHibernateSearchController"... przesyajc wiadomo JMS do metody "onMessage". 
 * 
 * W rodowisku JEE moesz opakowa wasn klas potomn jako bean sterowany wiadomociami (jak sugeruje dokumentacja
 * Hibernate Search).  Niemniej jednak "AbstractJMSHibernateSearchController" nie wymaga penego stosu JEE. 
 * Tak dugo jak twj framework (lub czysty kod) potrafi monitorowa kolejk JMS nie blokujc gwnego wtku aplikacji
 * main thread, moe przekazywa wiadomoci JMS do klas potomnych tego kontrolera.
 */
public class QueueController extends AbstractJMSHibernateSearchController {

	private Session session;
	
	public QueueController(Session session) {
		this.session = session;
	}
	
	@Override
	protected Session getSession() {
		return this.session;
	}

	@Override
	protected void cleanSessionIfNeeded(Session session) {
	}

}
