/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.ant;

import java.io.File;
import java.util.List;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.mortbay.jetty.ant.utils.TaskLog;

public class AntWebXmlConfiguration
extends WebXmlConfiguration {
    private static final Logger LOG = Log.getLogger(WebXmlConfiguration.class);
    private List classPathFiles;
    private File webAppBaseDir;
    private File webXmlFile;
    private File webDefaultXmlFile;

    public File getWebDefaultXmlFile() {
        return this.webDefaultXmlFile;
    }

    public void setWebDefaultXmlFile(File webDefaultXmlfile) {
        this.webDefaultXmlFile = webDefaultXmlfile;
    }

    public void setClassPathFiles(List classPathFiles) {
        this.classPathFiles = classPathFiles;
    }

    public void setWebAppBaseDir(File webAppBaseDir) {
        this.webAppBaseDir = webAppBaseDir;
    }

    public void setWebXmlFile(File webXmlFile) {
        this.webXmlFile = webXmlFile;
        if (webXmlFile.exists()) {
            TaskLog.log("web.xml file = " + webXmlFile);
        }
    }

    public void configure(WebAppContext context) throws Exception {
        if (context.isStarted()) {
            TaskLog.log("Cannot configure webapp after it is started");
            return;
        }
        if (this.webXmlFile.exists()) {
            context.setDescriptor(this.webXmlFile.getCanonicalPath());
        }
        super.configure(context);
        for (File classPathFile : this.classPathFiles) {
            if (!classPathFile.exists()) continue;
            ((WebAppClassLoader)context.getClassLoader()).addClassPath(classPathFile.getCanonicalPath());
        }
    }
}

