<?php
  // Niestandardowa funkcja, która tworzy wykres słupkowy na podstawie
  // zbioru danych, wartości maksymalnej i nazwy pliku graficznego.
  function draw_bar_graph($width, $height, $data, $max_value, $filename) {
    // Tworzenie pustego rysunku wykresu.
    $img = imagecreatetruecolor($width, $height);

    // Ustawianie białego tła i koloru tekstu, czarnych słupków i szarej ramki. 
    $bg_color = imagecolorallocate  ($img, 255, 255, 255); // Biały.
    $text_color = imagecolorallocate  ($img, 255, 255, 255); // Biały.
    $bar_color = imagecolorallocate  ($img, 0, 0, 0); // Czarny.
    $border_color = imagecolorallocate  ($img, 192, 192, 192); // Jasnoszary.

    // Wypełnianie tła.
    imagefilledrectangle($img, 0, 0, $width, $height, $bg_color);

    // Rysowanie słupków.
    $bar_width = $width / ((count($data) * 2) + 1);
    for ($i = 0; $i < count($data); $i++) {
      imagefilledrectangle($img, ($i * $bar_width * 2) + $bar_width, $height,
        ($i * $bar_width * 2) + ($bar_width * 2), $height - (($height / $max_value) * $data[$i][1]), $bar_color);
      imagestringup($img, 5, ($i * $bar_width * 2) + ($bar_width), $height - 5, $data[$i][0], $text_color);
    }

    // Rysowanie prostokątu wokół całego wykresu.
    imagerectangle($img, 0, 0, $width - 1, $height - 1, $border_color);

    // Rysowanie skala wzdłuż lewej krawędzi diagramu.
    for ($i = 1; $i <= $max_value; $i++) {
      imagestring($img, 5, 0, $height - ($i * ($height / $max_value)), $i, $bar_color);
    }

    // Zapisywanie rysunku z wykresem do pliku.
    imagepng($img, $filename, 5);
    imagedestroy($img);
  } // Koniec funkcji draw_bar_graph().

  // Uruchamianie sesji.
  require_once('startsession.php');

  // Wstawianie nagłówka strony.
  $page_title = 'Kojarzenie par';
  require_once('header.php');

  require_once('appvars.php');
  require_once('connectvars.php');

  // Przed przejściem do dalszych operacji należy się upewnić, że użytkownik jest zalogowany.
  if (!isset($_SESSION['user_id'])) {
    echo '<p class="login"><a href="login.php">Zaloguj się</a>, aby uzyskać dostęp do strony.</p>';
    exit();
  }

  // Wyświetlanie menu nawigacyjnego.
  require_once('navmenu.php');

  // Łączenie się z bazą danych.
  $dbc = mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);

  // Skrypt szuka partnera dla osób, które wypełniły już kwestionariusz.
  $query = "SELECT * FROM mismatch_response WHERE user_id = '" . $_SESSION['user_id'] . "'";
  $data = mysqli_query($dbc, $query);
  if (mysqli_num_rows($data) != 0) {
    // Najpierw należy pobrać oceny użytkownika z ich tabeli (instrukcja JOIN pozwala dołączyć nazwy tematów).
    $query = "SELECT mr.response_id, mr.topic_id, mr.response, mt.name AS topic_name, mc.name AS category_name " .
      "FROM mismatch_response AS mr " .
      "INNER JOIN mismatch_topic AS mt USING (topic_id) " .
      "INNER JOIN mismatch_category AS mc USING (category_id) " .
      "WHERE mr.user_id = '" . $_SESSION['user_id'] . "'";
    $data = mysqli_query($dbc, $query);
    $user_responses = array();
    while ($row = mysqli_fetch_array($data)) {
      array_push($user_responses, $row);
    }

    // Inicjowanie zmiennych na wyniki wyszukiwania.
    $mismatch_score = 0;
    $mismatch_user_id = -1;
    $mismatch_topics = array();
    $mismatch_categories = array();

    // Przejście w pętli po tabeli użytkowników i porównanie ich ocen z odpowiedziami aktualnie zalogowanej osoby.
    $query = "SELECT user_id FROM mismatch_user WHERE user_id != '" . $_SESSION['user_id'] . "'";
    $data = mysqli_query($dbc, $query);
    while ($row = mysqli_fetch_array($data)) {
      // Pobieranie ocen danego użytkownika (potencjalnego partnera).
      $query2 = "SELECT response_id, topic_id, response FROM mismatch_response WHERE user_id = '" . $row['user_id'] . "'";
      $data2 = mysqli_query($dbc, $query2);
      $mismatch_responses = array();
      while ($row2 = mysqli_fetch_array($data2)) {
        array_push($mismatch_responses, $row2);
      } // Koniec wewnętrznej pętli while.

      // Porównanie wszystkich ocen i obliczenie poziomu niedopasowania.
      $score = 0;
      $topics = array();
      $categories = array();
      for ($i = 0; $i < count($user_responses); $i++) {
        if ($user_responses[$i]['response'] + $mismatch_responses[$i]['response'] == 3) {
          $score += 1;
          array_push($topics, $user_responses[$i]['topic_name']);
          array_push($categories, $user_responses[$i]['category_name']);
        }
      }

      // Sprawdzanie, czy dana osoba jest najbardziej niedopasowana z dotychczas ocenionych.
      if ($score > $mismatch_score) {
        // Znaleźliśmy bardziej niedopasowaną osobę, dlatego należy zaktualizować wyniki.
        $mismatch_score = $score;
        $mismatch_user_id = $row['user_id'];
        $mismatch_topics = array_slice($topics, 0);
        $mismatch_categories = array_slice($categories, 0);
      }
    } // Koniec zewnętrznej pętli while.

    // Sprawdzanie, czy znaleziono niedopasowanego partnera.
    if ($mismatch_user_id != -1) {
      $query = "SELECT username, first_name, last_name, city, state, picture FROM mismatch_user WHERE user_id = '$mismatch_user_id'";
      $data = mysqli_query($dbc, $query);
      if (mysqli_num_rows($data) == 1) {
        // Znaleziono wiersz z danymi niedopasowanej osoby, dlatego można je wyświetlić.
        $row = mysqli_fetch_array($data);
        echo '<table><tr><td class="label">';
        if (!empty($row['first_name']) && !empty($row['last_name'])) {
          echo $row['first_name'] . ' ' . $row['last_name'] . '<br />';
        }
        if (!empty($row['city']) && !empty($row['state'])) {
          echo $row['city'] . ', ' . $row['state'] . '<br />';
        }
        echo '</td><td>';
        if (!empty($row['picture'])) {
          echo '<img src="' . MM_UPLOADPATH . $row['picture'] . '" alt="Zdjęcie z profilu" /><br />';
        }
        echo '</td></tr></table>';

        // Wyświetlanie niedopasowanych tematów w czterech kolumnach tabeli.
        echo '<h4>Liczba tematów z przeciwnymi ocenami: ' . count($mismatch_topics) . 
          '. Są to:</h4>';
        echo '<table><tr>';
        $i = 0;
        foreach ($mismatch_topics as $topic) {
          echo '<td>' . $topic . '</td>';
          if (++$i > 3) {
            echo '</tr><tr>';
            $i = 0;
          }
        }
        echo '</tr></table>';

        // Określanie liczby niedopasowanych tematów w każdej kategorii.
        $category_totals = array(array($mismatch_categories[0], 0));
        foreach ($mismatch_categories as $category) {
          if ($category_totals[count($category_totals) - 1][0] != $category) {
            array_push($category_totals, array($category, 1));
          }
          else {
            $category_totals[count($category_totals) - 1][1]++;
          }
        }

        // Generowanie i wyświetlanie wykresu słupkowego z kategoriami niedopasowanych tematów.
        echo '<h4>Wymiary niedopasowania:</h4>';
        draw_bar_graph(480, 240, $category_totals, 5, MM_UPLOADPATH . 'mymismatchgraph.png');
        echo '<img src="' . MM_UPLOADPATH . 'mymismatchgraph.png" alt="Wykres kategorii" /><br />';

        // Wyświetlanie odnośnika do profilu niedopasowanej osoby.
        echo '<h4>Zobacz profil użytkownika <a href=viewprofile.php?user_id=' . 
          $mismatch_user_id . '>' . $row['first_name'] . '</a>.</h4>';
      } // Koniec sprawdzania dostępności wiersza z danymi niedopasowanego użytkownika.
    } // Koniec sprawdzania dostępności niedopasowanego partnera.
  } // Koniec sprawdzania dostępności odpowiedzi użytkownika.
  else {
    echo '<p>Przed znalezieniem partnera musisz najpierw ' . 
         '<a href="questionnaire.php">wypełnić kwestionariusz</a>.</p>';
  }

  mysqli_close($dbc);

  // Wstawianie stopki.
  require_once('footer.php');
?>
