<?php
  // Jeśli użytkownik jest zalogowany, należy usunąć zmienne sesji, aby go wylogować.
  session_start();
  if (isset($_SESSION['user_id'])) {
    // Usunięcie zmiennych sesji przez wykasowanie elementów tablicy $_SESSION.
    $_SESSION = array();

    // Usunięcie pliku cookie sesji przez ustawienie daty wygasania na godzinę (3600 sekund) wstecz.
    if (isset($_COOKIE[session_name()])) {
      setcookie(session_name(), '', time() - 3600);
    }

    // Kończenie sesji.
    session_destroy();
  }

  // Usunięcie plików cookie z identyfikatorem i nazwą użytkownika
  // przez ustawienie ich daty wygasania na godzinę wstecz (3600 sekund).
  setcookie('user_id', '', time() - 3600);
  setcookie('username', '', time() - 3600);

  // Skierowanie użytkownika do strony głównej.
  $home_url = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/index.php';
  header('Location: ' . $home_url);
?>
