﻿<?php
  define('YOUTUBE_URL', 'http://gdata.youtube.com/feeds/api/users/aliensabductedme/favorites');
  define('NUM_VIDEOS', 5);

  // Wczytywanie danych XML do obiektu.
  $xml = simplexml_load_file(YOUTUBE_URL);

  $num_videos_found = count($xml->entry);
  if ($num_videos_found > 0) {
    echo '<table><tr>';
    for ($i = 0; $i < min($num_videos_found, NUM_VIDEOS); $i++) {
      // Pobieranie tytułu.
      $entry = $xml->entry[$i];
      $media = $entry->children('http://search.yahoo.com/mrss/');
      $title = $media->group->title;

      // Określanie czasu trwania filmu w minutach i sekundach oraz formatowanie go.
      $yt = $media->children('http://gdata.youtube.com/schemas/2007');
      $attrs = $yt->duration->attributes();
      $length_min = floor($attrs['seconds'] / 60);
      $length_sec = $attrs['seconds'] % 60;
      $length_formatted = $length_min . ' minut, ' .
        $length_sec . ' sekund';

      // Pobieranie adresu URL filmu.
      $attrs = $media->group->player->attributes();
      $video_url = $attrs['url'];

      // Pobieranie adresu URL miniatury.
      $attrs = $media->group->thumbnail[0]->attributes();
      $thumbnail_url = $attrs['url']; 

      // Wyświetlanie informacji związanych z danym filmem.
      echo '<td style="vertical-align:bottom; text-align:center" width="' . (100 / NUM_VIDEOS) . '%"><a href="' . $video_url . '">' .
        $title . '<br /><span style="font-size:smaller">' . $length_formatted . '</span><br /><img src="' . $thumbnail_url . '" /></a></td>';
    }
    echo '</tr></table>';
  }
  else {
    echo '<p>Nie znaleziono żadnego filmu.</p>';
  }
?>
