public class DogDoorSimulator {

  public static void main(String[] args) {
    DogDoor door = new DogDoor();
    door.addAllowedBark(new Bark("hauu"));
    door.addAllowedBark(new Bark("wrrrrr"));
    door.addAllowedBark(new Bark("hauhauu"));
    door.addAllowedBark(new Bark("hauuuuu"));
    BarkRecognizer recognizer = new BarkRecognizer(door);
    Remote remote = new Remote(door);

    // Symulujemy "usyszenie" szczekania przez system
    System.out.println("Brus zaczyna szczeka.");
    recognizer.recognize(new Bark("hauu"));

    System.out.println("\nBrus wyszed na zewntrz...");

    try {
      Thread.currentThread().sleep(10000);
    } catch (InterruptedException e) { }

    System.out.println("\nBrus zaatwi swoje potrzeby...");
    System.out.println("...ale utkn na zewntrz!");

    // Symulujemy "ususzenie" szczekania (ale nie Brusa!)
    Bark smallDogBark = new Bark("hiaaau");
    System.out.println("May pies zacz szczeka.");
    recognizer.recognize(smallDogBark);

    try {
      Thread.currentThread().sleep(5000);
    } catch (InterruptedException e) { }

    // Symulujemy "usyszenie" szczekania przez system (ponownie)
    System.out.println("\nBrus zaczyna szczeka.");
    recognizer.recognize(new Bark("hauu"));

    System.out.println("\nBrus znowu jest w domu...");
  }
}
