// Konstruktor obiektu AjaxRequest 
function AjaxRequest() {
  // Try the XMLHttpRequest object first
  if (window.XMLHttpRequest) {
    try {
      this.request = new XMLHttpRequest();
    } catch(e) {
      this.request = null;
    }
  // Now try the ActiveX (IE) version
  } else if (window.ActiveXObject) {
    try {
      this.request = new ActiveXObject("Msxml2.XMLHTTP");
    // Try the older ActiveX object for older versions of IE
    } catch(e) {
      try {
        this.request = new ActiveXObject("Microsoft.XMLHTTP");
      } catch(e) {
        this.request = null;
      }
    }
  }

  // If the request creation failed, notify the user
  if (this.request == null)
    alert("Ajax error creating the request.\n" + "Details: " + e);
}

// Przesamy danie na serwer uywajc technolgoii Ajax
AjaxRequest.prototype.send = function(type, url, handler, postDataType, postData) {
  if (this.request != null) {
    // Usuwamy wczeniejsze danie
    this.request.abort();

    // Dodajemy pomocniczy parametr by zapobiec pobraniu odpowiedzi 
    // z pamici podrcznej przegldarki
    url += "?dummy=" + new Date().getTime();

    try {
      this.request.onreadystatechange = handler;
      this.request.open(type, url, true); // zawsze asynchroniczne (true)
      if (type.toLowerCase() == "get") {
        // Generujemy danie GET: brak danych 
        this.request.send(null);
      } else {
        // Generujemy adanie POST: ostatni argument to dane
        this.request.setRequestHeader("Content-Type", postDataType);
        this.request.send(postData);
      }
    } catch(e) {
      alert("Bd komunikacji z serwerem.\n" + "Informacje szczegowe: " + e);
    }
  }
}

AjaxRequest.prototype.getReadyState = function() {
  return this.request.readyState;
}

AjaxRequest.prototype.getStatus = function() {
  return this.request.status;
}

AjaxRequest.prototype.getResponseText = function() {
  return this.request.responseText;
}

AjaxRequest.prototype.getResponseXML = function() {
  return this.request.responseXML;
}
