# Listing_17-3.py
# Copyright Warren & Carter Sande, 2013
# Released under MIT license   http://www.opensource.org/licenses/mit-license.php
# Version $version  ----------------------------

# Wykrywanie zderze odbijanie od siebie piek)
# z wykorzystaniem grupy sprajtw (zamiast listy)

import sys, pygame
from random import *

#-----definicja klasy pochodnej -----------------------------
class KlasaMojaPilka(pygame.sprite.Sprite):
    def __init__(self, plik_obrazka, polozenie, predkosc):
        pygame.sprite.Sprite.__init__(self)
        self.image = pygame.image.load(plik_obrazka)
        self.rect = self.image.get_rect()
        self.rect.left, self.rect.top = polozenie
        self.predkosc = predkosc

    def przesun(self):
        self.rect = self.rect.move(self.predkosc)
        # sprawdzamy, czy pika uderzya w boczn krawd okna
        # jeeli tak, odwracamy kierunek ruchu piki w osi x
        if self.rect.left < 0 or self.rect.right > szerokosc:
            self.predkosc[0] = -self.predkosc[0]
        # sprawdzamy, czy pika uderzya w grn bd doln krawd okna
        # jeeli tak, odwracamy kierunek ruchu piki w osi y    
        if self.rect.top < 0 or self.rect.bottom > wysokosc:
            self.predkosc[1] = -self.predkosc[1]

#----- definicja funkcji -----------------------  
def animuj(grupa):
    ekran.fill([255,255,255])
    for pilka in grupa:
        # usuwamy sprajta z grupy
        grupa.remove(pilka)

        # sprawdzamy, czy nie nastpio zderzenie sprajta z pozostaymi sprajtami z grupy
        if pygame.sprite.spritecollide(pilka, grupa, False):
            pilka.predkosc[0] = -pilka.predkosc[0]
            pilka.predkosc [1] = -pilka.predkosc [1]

        # wstawiamy z powrotem pik do grupy  
        grupa.add(pilka)
        pilka.przesun()
        ekran.blit(pilka.image, pilka.rect)
    pygame.display.flip()
    pygame.time.delay(20)

#----- gwny program -----------------------------
rozmiar = szerokosc, wysokosc = 640, 480
ekran = pygame.display.set_mode(rozmiar)
ekran.fill([255, 255, 255])
plik_obrazka = "beach_ball.png"
grupa = pygame.sprite.Group()
for wiersz in range (0, 2):
    for kolumna in range (0, 2):
        polozenie = [kolumna * 180 + 10, wiersz * 180 + 10]
        predkosc = [choice([-2, 2]), choice([-2, 2])]
        pilka = KlasaMojaPilka(plik_obrazka, polozenie, predkosc)
        grupa.add(pilka)    # dodajemy pik do grupy

uruchomiony = True
while uruchomiony:
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            uruchomiony = False
    animuj(grupa)
pygame.quit()
