#! /usr/bin/python3

#install https://github.com/juhasch/pyBusPirateLite

instructions = {
    "READ"  : 0x3,
    "WAKE"  : 0xab,
    "RDID"  : 0x9f,
}


def get_data_chunk(spi,dummy_send):
    spi.cs = True
    data = bytes(spi.transfer( dummy_send ))
    spi.cs = False
    return data

from pyBusPirateLite.SPI import *
import time

curr_addr = 0;
data = bytes()
dummy_send = [0] * 256
# !! BPv4 , change for BPv3
spi = SPI("/dev/ttyACM0",115200)
spi.speed='250kHz'
spi.pins=  SPI.PIN_POWER| SPI.PIN_CS # enable vreg
spi.config = SPI.CFG_PUSH_PULL|SPI.CFG_CLK_EDGE # sample middle, active to idle, phae low

spi.enter()


spi.cs = True
data += bytes(spi.transfer( [ instructions["WAKE"] ]        ) )
spi.cs = False
time.sleep(0.05)
addr = 0x00;
eprom_sz = 1024*1024*4
read_sz = 256

spi.cs = True
data = bytes(
    spi.write_then_read (
        1,
        3,
        [ instructions["RDID"]
        ]
))

spi.cs = False
print("jdec : " + str(data))
