/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/
package org.przyklad.grafika;

import org.przyklad.grafika.R;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Path.Direction;
import android.os.Bundle;
import android.view.View;

public class Grafika extends Activity {
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(new WidokGrafika(this));
    }

    static public class WidokGrafika extends View {
    	
    	private static final String CYTAT = "Nadszed czas, by wszyscy" +
        " dobrzy obywatele wspomogli sw ojczyzn." ;
    	
        private final Path okrag;
        private final Paint cObraz;
        private final Paint tObraz;

        
        public WidokGrafika(Context kontekst) {
           super(kontekst);
           
           // Przykadowe kolory
           
           int kolor = Color.BLUE; // jednolity niebieski
           
           
           // Przewitujcy purpurowy
           kolor = Color.argb(127, 255, 0, 255);
           
           
           kolor = getResources().getColor(R.color.mojkolor);
           

           
           okrag = new Path();
           okrag.addCircle(150, 150, 100, Direction.CW);
           

           cObraz = new Paint(Paint.ANTI_ALIAS_FLAG);
           cObraz.setStyle(Paint.Style.STROKE);
           
           cObraz.setColor(Color.LTGRAY);
           
           cObraz.setStrokeWidth(3);

           tObraz = new Paint(Paint.ANTI_ALIAS_FLAG);
           tObraz.setStyle(Paint.Style.FILL_AND_STROKE);
           tObraz.setColor(Color.BLACK);
           tObraz.setTextSize(20f);

           // setBackgroundColor(Color.WHITE);
           
           setBackgroundResource(R.drawable.tlo);
           
           
        }
             
        @Override
        protected void onDraw(Canvas plotno) {
           // Tutaj wstawiamy polecenia rysowania
           
           
           plotno.drawPath(okrag, cObraz);
           plotno.drawTextOnPath(CYTAT, okrag, 0, 20, tObraz);
           
           
        }
     }
  }