/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/
package org.przyklad.sudoku;

import android.app.Activity;
import android.os.Bundle;

import android.content.Intent;
import android.view.View;
import android.view.View.OnClickListener;

import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.util.Log;

public class Sudoku extends Activity implements OnClickListener {
	
	private static final String ZNACZNIK = "Sudoku" ;
	
	
    /** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);
	    setContentView(R.layout.main);

	    // Konfigurujemy obiekty nasuchujce klikni dla wszystkich przyciskw
	    View przyciskKontynuacja = findViewById(R.id.przycisk_kontynuacja);
	    przyciskKontynuacja.setOnClickListener(this);
	    View przyciskNowa = findViewById(R.id.przycisk_nowa);
	    przyciskNowa.setOnClickListener(this);
	    View przyciskInformacje = findViewById(R.id.przycisk_informacje);
	    przyciskInformacje.setOnClickListener(this);
	    View przyciskWyjscie = findViewById(R.id.przycisk_wyjscie);
	    przyciskWyjscie.setOnClickListener(this);
	}
	
	// ...
    public void onClick(View v) {
        switch (v.getId()) {
        case R.id.przycisk_informacje:
            Intent i = new Intent(this, Informacje.class);
            startActivity(i);
            break;
        // Tutaj definiujemy wicej klawiszy (jeli s jakie)
            
        case R.id.przycisk_nowa:
        	otworzDialogNowaGra();
        	break;
        	
        case R.id.przycisk_wyjscie:
            finish();
            break;
        }
    }
    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        MenuInflater wypelniacz = getMenuInflater();
        wypelniacz.inflate(R.menu.menu, menu);
        return true;
    }
    
    @Override
    public boolean onOptionsItemSelected(MenuItem element) {
        switch (element.getItemId()) {
        case R.id.ustawienia:
            startActivity(new Intent(this, Preferencje.class));
            return true;
        // Wstawiamy tutaj pozostae elementy (jeli jakie bd) ...
        }
        return false;
    }
    
    
    /** Pytamy uytkownika o poziom trudnoci */
    private void otworzDialogNowaGra() {
        new AlertDialog.Builder(this)
            .setTitle(R.string.tytul_nowa_gra)
            .setItems(R.array.trudnosc,
            new DialogInterface.OnClickListener() {
                public void onClick(DialogInterface dialoginterface, int i) {
                    uruchomGre(i);
                }
            })
            .show();
    }

    /** Rozpoczyna now gr na wybranym poziomie trudnoci */
    private void uruchomGre(int i) {
        Log.d(ZNACZNIK, "kliknito " + i);
        Intent intencja = new Intent(Sudoku.this, Gra.class);
        intencja.putExtra(Gra.TRUDNOSC_KLUCZ, i);
        startActivity(intencja);
    }
}

	
