/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/
package org.przyklad.zdarzenia;

import static android.provider.BaseColumns._ID;
import static org.przyklad.zdarzenia.Stale.CZAS;
import static org.przyklad.zdarzenia.Stale.TYTUL;
import android.content.ContentValues;
import android.database.Cursor;
import android.os.Bundle;
import android.app.ListActivity;
import android.widget.SimpleCursorAdapter;

import static org.przyklad.zdarzenia.Stale.TRESC_URI;

public class Zdarzenia extends ListActivity {
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        dodajZdarzenie("Witaj, Androidzie!" );
        Cursor kursor = wezZdarzenia();
        pokazZdarzenia(kursor);
    }

                 
    private void dodajZdarzenie(String string) {
        // Wstawia nowy rekord do rda danych Zdarzenia.
        // Podobnie wyglda proces usuwania i aktualizowania rekordw.
        ContentValues wartosci = new ContentValues();
        wartosci.put(CZAS, System.currentTimeMillis());
        wartosci.put(TYTUL, string);
        getContentResolver().insert(TRESC_URI, wartosci);
    }


    private static String[] FROM = { _ID, CZAS, TYTUL, };
    private static String ORDER_BY = CZAS + " DESC" ;
    private static int[] DO = { R.id.idwiersza, R.id.czas, R.id.tytul, };

    
    private Cursor wezZdarzenia() {
        // Przeprowadza zarzdzan kwerend. W razie potrzeby Aktywno zajmie si
        // zamykaniem kursora i wysaniem do niego ponownego zapytania.
        return managedQuery(TRESC_URI, FROM, null, null, ORDER_BY);
    }
                                  
    private void pokazZdarzenia(Cursor kursor) {
        // Konfiguruje wizanie danych
        SimpleCursorAdapter adapter = new SimpleCursorAdapter(this,
            R.layout.element, kursor, FROM, DO);
        setListAdapter(adapter);
    }

}
