/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/

package org.przyklad.dotyk;

import android.view.MotionEvent;

public class OpakujZdarzenieRuchu {
    protected MotionEvent zdarzenie;
    
    protected OpakujZdarzenieRuchu(MotionEvent zdarzenie) {
        this.zdarzenie = zdarzenie;
    }

    static public OpakujZdarzenieRuchu opakuj(MotionEvent zdarzenie) {
        try {
            return new EclairZdarzenieRuchu(zdarzenie);
        } catch (VerifyError e) {
            return new OpakujZdarzenieRuchu(zdarzenie);
        }
    }

public int getAction() {
    return zdarzenie.getAction();
}

public float getX() {
    return zdarzenie.getX();
}

public float getX(int indeksWskaznika) {
    verifyPointerIndex(indeksWskaznika);
    return getX();
}

public float getY() {
    return zdarzenie.getY();
}

public float getY(int indeksWskaznika) {
    verifyPointerIndex(indeksWskaznika);
    return getY();
}

public int getPointerCount() {
    return 1;
}

public int getPointerId(int indeksWskaznika) {
    verifyPointerIndex(indeksWskaznika);
    return 0;
}

private void verifyPointerIndex(int indeksWskaznika) {
    if (indeksWskaznika > 0) {
        throw new IllegalArgumentException(
            "Nieprawidlowy indeks wskaznika dla wersji Donut/Cupcake" );
        }
    }


}
