/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/
package org.przyklad.translator;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.AdapterView.OnItemSelectedListener;

public class Translator extends Activity {
    private Spinner zSpinner;
    private Spinner naSpinner;
    private EditText tekstOryg;
    private TextView tekstTlum;
    private TextView tekstPonTlum;

    private TextWatcher obserwatorTekstu;
    private OnItemSelectedListener nasluchWyboruElementu;

    private Handler watekGui;
    private ExecutorService watekTlum;
    private Runnable zadanieAktualizacja;
    private Future trwajaceTlum;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.main);
        inicjacjaWatkowania();
        znajdzWidoki();
        ustawAdaptery();
        ustawObiektyNasluchujace();
    }
    
    @Override
    protected void onDestroy() {
       // Wycza tutaj dodatkowe wtki
       watekTlum.shutdownNow();
       super.onDestroy();
    }
                 
    /** Generuje uchwyt dla wszystkich elementw interfejsu uytkownika */
    private void znajdzWidoki() {
        zSpinner = (Spinner) findViewById(R.id.z_jezyka);
        naSpinner = (Spinner) findViewById(R.id.na_jezyk);
        tekstOryg = (EditText) findViewById(R.id.tekst_oryginal);
        tekstTlum = (TextView) findViewById(R.id.tekst_przetlumaczony);
        tekstPonTlum = (TextView) findViewById(R.id.tekst_pon_przetlumaczony);
    }
   
    /** Definiuje rdo danych dla obiektw typu Spinner */
    private void ustawAdaptery() {
        // Lista danych dla obiektu Spinner pochodzi z zasobu,
        // Interfejs uyt. obiektu Spinner korzysta ze standardowych ukadw graf.
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(
            this, R.array.jezyki,
            android.R.layout.simple_spinner_item);
            adapter.setDropDownViewResource(
                android.R.layout.simple_spinner_dropdown_item);
            zSpinner.setAdapter(adapter);
            naSpinner.setAdapter(adapter);

        // Automatycznie wybiera dwa elementy w obiektach typu Spinner
        zSpinner.setSelection(21); // Polski (pl)
        naSpinner.setSelection(9); // Francuski (fr)
    }

    /** Konfiguruje procedury obsugi zdarze zwizanych z interfejsem uytkownika */
    private void ustawObiektyNasluchujace() {
        // Definiuje obiekty nasuchujce zdarze
        obserwatorTekstu = new TextWatcher() {
            public void beforeTextChanged(CharSequence s, int start,
                    int licz, int po) {
                /* Nic nie rb */
        }
        public void onTextChanged(CharSequence s, int start,
                int przed, int licz) {
            aktualizacjaKolejki(1000 /* millisekundy */);
        }
        public void afterTextChanged (Editable s) {
            /* Nic nie rb */
        }
    };
    nasluchWyboruElementu = new OnItemSelectedListener() {
        public void onItemSelected(AdapterView rodzic, View v,
            int pozycja, long id) {
        aktualizacjaKolejki(200 /* millisekundy */);
    }
    public void onNothingSelected(AdapterView rodzic) {
        /* Nic nie rb */
    }
   };

   // Rejestruje obiekty nasuchujce widetw graficznego interfejsu uytkownika
   tekstOryg.addTextChangedListener(obserwatorTekstu);
   zSpinner.setOnItemSelectedListener(nasluchWyboruElementu);
   naSpinner.setOnItemSelectedListener(nasluchWyboruElementu);
  }

    /**
     * Inicjacja wielowtkowoci. Wygenerowane zostaj dwa wtki: 1) Wtek gwnego
     * graficznego interfejsu uytkownika, ju uruchomiony przez system Android,
     * oraz 2) Wtek tumaczenia, ktry zostaje zapocztkowany za pomoc egzekutora.
     */
    private void inicjacjaWatkowania() {
        watekGui = new Handler();
        watekTlum = Executors.newSingleThreadExecutor();
                	 
        // To zadanie odpowiada za tumaczenie oraz aktualizacj ekranu
        zadanieAktualizacja = new Runnable() {
            public void run() {
                // Pobiera tekst do tumaczenia
                String oryginal = tekstOryg.getText().toString().trim();
                	 
                // Anuluje poprzednie tumaczenie, jeli takie byo
                if (trwajaceTlum != null)
                    trwajaceTlum.cancel(true);
                	 
                // Zajmuje si prostymi przypadkami
                if (oryginal.length() == 0) {
                    tekstTlum.setText(R.string.pusty);
                	tekstPonTlum.setText(R.string.pusty);
                } else {
                    // Niech uytkownik wie, e co si dzieje
                    tekstTlum.setText(R.string.tlumaczenie);
                    tekstPonTlum.setText(R.string.tlumaczenie);
                	 
                    // Rozpocznij tumaczenie, ale nie czekaj
                    try {
                      ZadanieTlum zadanieTlumaczenia = new ZadanieTlum(
                        Translator.this, // referencja do aktywnoci                             
                        oryginal, // tekst oryginalny
                        wezJezyk(zSpinner), // z jzyka
                        wezJezyk(naSpinner) // na jzyk
                      );
                      trwajaceTlum = watekTlum.submit(zadanieTlumaczenia);
                    } catch (RejectedExecutionException e) {
                	  // Nie mona rozpocz nowego zadania
                	  tekstTlum.setText(R.string.tlumaczenie_blad);
                	  tekstPonTlum.setText(R.string.tlumaczenie_blad);
                	}
                }
            }
        };
    }
                               
    /** Odczytuje kod jzyka z biecego elementu w obiekcie Spinner */
    private String wezJezyk(Spinner spinner) {
        String wynik = spinner.getSelectedItem().toString();
        int lrodzic = wynik.indexOf('(' );
        int prodzic = wynik.indexOf(')' );
        wynik = wynik.substring(lrodzic + 1, prodzic);
        return wynik;
    }

    /** da rozpoczcia aktualizacji po krtkim opnieniu */
    private void aktualizacjaKolejki(long opoznienieMillis) {
        // Anuluje poprzedni aktualizacj, jeli nie zostaa jeszcze rozpoczta
        watekGui.removeCallbacks(zadanieAktualizacja);
        // Rozpoczyna aktualizacj, jeli nic si nie bdzie dziao przez kilka ms
        watekGui.postDelayed(zadanieAktualizacja, opoznienieMillis);
    }

    /** Modyfikuje tekst na ekranie (wywoywane z drugiego wtku) */
    public void ustawPrzetlumaczone(String tekst) {
        guiUstawTekst(tekstTlum, tekst);
    }

    /** Modyfikuje tekst na ekranie (wywoywane z drugiego wtku) */
    public void ustawPonowniePrzetlum(String tekst) {
        guiUstawTekst(tekstPonTlum, tekst);
    }

    /** Wszystkie zmiany w interfejsie graficznym musz zosta dokonane w wtku GUI */
    private void guiUstawTekst(final TextView widok, final String tekst) {
        watekGui.post(new Runnable() {
            public void run() {
                widok.setText(tekst);
            }
        });
    } 
}
