/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/
package org.przyklad.zdarzenia;

import static android.provider.BaseColumns._ID;
import static org.przyklad.zdarzenia.Stale.NAZWA_TABELI;
import static org.przyklad.zdarzenia.Stale.CZAS;
import static org.przyklad.zdarzenia.Stale.TYTUL;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.app.ListActivity;
import android.widget.SimpleCursorAdapter;

public class Zdarzenia extends ListActivity {
	
    private DaneZdarzen zdarzenia;
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        zdarzenia = new DaneZdarzen(this);
        try {
            dodajZdarzenie("Witaj, Androidzie!" );
            Cursor kursor = wezZdarzenia();
            pokazZdarzenia(kursor);
        } finally {
            zdarzenia.close();
        }
    }
                 
    private void dodajZdarzenie(String string) {
        // Wstawia nowy rekord do rda danych Zdarzenia.
        // Podobnie wyglda proces usuwania i aktualizowania rekordw.
        SQLiteDatabase bd = zdarzenia.getWritableDatabase();
        ContentValues wartosci = new ContentValues();
        wartosci.put(CZAS, System.currentTimeMillis());
        wartosci.put(TYTUL, string);
        bd.insertOrThrow(NAZWA_TABELI, null, wartosci);
    }

    private static String[] FROM = { _ID, CZAS, TYTUL, };
    private static String ORDER_BY = CZAS + " DESC" ;
    private static int[] DO = { R.id.idwiersza, R.id.czas, R.id.tytul, };
    private Cursor wezZdarzenia() {
        // Przeprowadza zarzdzane zapytanie. W razie potrzeby Aktywno zajmie si
        // zamykaniem kursora i jego ponownym zapytaniem.
        SQLiteDatabase bd = zdarzenia.getReadableDatabase();
        Cursor kursor = bd.query(NAZWA_TABELI, FROM, null, null, null,
            null, ORDER_BY);
        startManagingCursor(kursor);
        return kursor;
    }
                                  
    private void pokazZdarzenia(Cursor kursor) {
        // Konfiguruje wizanie danych
        SimpleCursorAdapter adapter = new SimpleCursorAdapter(this,
            R.layout.element, kursor, FROM, DO);
        setListAdapter(adapter);
    }

}
