/***
 * Wycig z ksiki "Hello, Android!",
 * opublikowanej przez wydawnictwo Helion S.A.
 * Niniejszy kod jest chroniony prawami autorskimi. Nie moe zosta wykorzystany do utworzenia 
 * materiaw treningowych, kursw, ksiek, artykuw, itp. Prosimy o kontakt w razie
 * pojawienia si wtpliwoci.
 * Nie gwarantujemy, e niniejszy kod bdzie si nadawa do jakiegokolwiek celu. 
 * Wicej informacji mona znale na stronie http://www.pragmaticprogrammer.com/titles/eband.
***/
package org.przyklad.audio;

import android.app.Activity;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.view.KeyEvent;

public class Audio extends Activity {
    private MediaPlayer mp;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        setVolumeControlStream(AudioManager.STREAM_MUSIC);
    }
    
    @Override
    public boolean onKeyDown(int kodKlaw, KeyEvent zdarzenie) {
        int idZas;
        switch (kodKlaw) {
        case KeyEvent.KEYCODE_DPAD_UP:
            idZas = R.raw.gora;
            break;
        case KeyEvent.KEYCODE_DPAD_DOWN:
            idZas = R.raw.dol;
            break;
        case KeyEvent.KEYCODE_DPAD_LEFT:
            idZas = R.raw.lewo;
            break;
        case KeyEvent.KEYCODE_DPAD_RIGHT:
            idZas = R.raw.prawo;
            break;
        case KeyEvent.KEYCODE_DPAD_CENTER:
        case KeyEvent.KEYCODE_ENTER:
            idZas = R.raw.enter;
            break;
        case KeyEvent.KEYCODE_A:
            idZas = R.raw.a;
            break;
        case KeyEvent.KEYCODE_S:
            idZas = R.raw.s;
            break;
        case KeyEvent.KEYCODE_D:
            idZas = R.raw.d;
            break;
        case KeyEvent.KEYCODE_F:
            idZas = R.raw.f;
            break;
        default:
            return super.onKeyDown(kodKlaw, zdarzenie);
        }
    
        // Zwalnia zasoby wczeniejszej instancji MediaPlayer
        if (mp != null) {
            mp.release();
        }
    
        // Tworzy now instancj MediaPlayer do odtwarzania dwiku
        mp = MediaPlayer.create(this, idZas);
        mp.start();
    
        // Wskazuje na to, e dany klawisz zosta obsuony
        return true;
    }
}
