author = "Autorzy książki"
desc = "Prosty skrypt zakłócający implementację NFC/RFID"

local tag = {}

local charset = {} do 
   for c = 48, 57 do table.insert(charset, string.char(c)) end
   for c = 97, 102 do table.insert(charset, string.char(c)) end
end

function load_seed_tag()
   print("Ładowanie ziarna tagu...").   
   core.console("hf mf eload CEA0B6B4")
   os.execute('sleep 5') 
   local infile = io.open("CEA0B6B4.eml", "r")
   if infile == nil then 
      print(string.format("Błąd odczytu pliku %s", tostring(input)))
   end
   local t = infile:read("*all")
   local i = 0
   for line in string.gmatch(t, "[^\n]+") do 
      if string.byte(line, 1) ~= string.byte("+", 1) then
         tag[i] = line
         i = i + 1
      end
   end
end

function randomize(block_start, block_end)
   local block = math.random(block_start, block_end)
   local position = math.random(0, 31)
   local value = charset[math.random(1, 16)]
   print("Modyfikowanie bloku " .. block .. " na pozycji " .. position)
   local string_head = tag[block]:sub(0, position)
   local string_tail = tag[block]:sub(position + 2)
   tag[block] = string_head .. value .. string_tail
   print(tag[block])
   core.console("hf mf eset " .. block .. " " .. tag[block])
   os.execute('sleep 5')
end

function fuzz()
   core.clearCommandBuffer()
   core.console("hf mf dbg 0")
   os.execute('sleep 5')
   while not core.ukbhit() do
      randomize(0,63)
      core.console("hf mf sim *1 u CEA0B6B4")
   end
   print("Operacja przerwana")
end

function main(args)
	load_seed_tag()
   fuzz()
end

main()