#include "heltec.h"
#define BAND 915E6

String packet;
unsigned int counter = 0;

void setup() {
  Heltec.begin(true, true, true, true, BAND);
  Heltec.display->init();
  Heltec.display->flipScreenVertically();
  Heltec.display->setFont(ArialMT_Plain_10);
  delay(1500);
  Heltec.display->clear();
  Heltec.display->drawString(0, 0, "Moduł Heltec zainicjowany pomyślnie!");
  Heltec.display->display();
  delay(1000);
}

void loop() {
  Heltec.display->clear();
  Heltec.display->setTextAlignment(TEXT_ALIGN_LEFT);
  Heltec.display->setFont(ArialMT_Plain_10);
  Heltec.display->drawString(0, 0, "Wysłanie pakietu nr ");
  Heltec.display->drawString(90, 0, String(counter));
  Heltec.display->display();

  LoRa.beginPacket();
  LoRa.disableCrc();
  LoRa.setSpreadingFactor(7);
  LoRa.setTxPower(20, RF_PACONFIG_PASELECT_PABOOST);
  LoRa.print("Niezbyt tajny komunikat LoRa");
  LoRa.endPacket();

  counter++;
  digitalWrite(LED, HIGH); // Włączenie diody LED (HIGH oznacza wysoki poziom napięcia)
  delay(1000);
  digitalWrite(LED, LOW); // Wyłączenie diody LED (LOW oznacza niski poziom napięcia)
  delay(1000);
}