import turtle
# importujemy moduł turtle
import datetime


# importujemy moduł datetime
# moduł ten pozwala na pobieranie czasu z systemu


def zegar(godziny, minuty, sekundy, rozmiar, x, y):
    # tworzymy funkcję o nazwie zegar
    # funkcja ta przyjmuje sześć argumentów
    # pierwsze trzy określają odpowiednio
    # wartość godzin, minut i sekund
    # kolejny argument określa promień tarczy zegara
    # ostatnie dwa argumenty określają pozycję
    # rysowanego zegara
    turtle.tracer(27)
    # przyspieszamy animację żółwia
    turtle.clear()
    # czyścimy to, co zostało narysowane 
    turtle.pencolor("black")
    # zmieniamy kolor linii, którą rysuje żółw, na czarny 
    turtle.pensize(2)
    # ustawiamy rozmiar linii, którą rysuje żółw,
    # na wartość równą 2 piksele 
    turtle.setheading(0)
    # ustawiamy kierunek żółwia na wartość zero
    # ustawienie to powoduje, że żółw będzie skierowany w prawo
    turtle.penup()
    # podnosimy żółwia, od tej pory
    # poruszając się, nie pozostawia za
    # sobą śladu w postaci linii
    turtle.goto(x, y - rozmiar)
    # przemieszczamy żółwia do wskazanej pozycji 
    # określonej przez zmienne x oraz y
    # od wartości y odejmowana jest
    # wartość zmiennej rozmiar 
    turtle.pendown()
    # opuszczamy żółwia, od tej pory
    # poruszając się, pozostawia za
    # sobą ślad w postaci linii

    # rysujemy tarczę oraz oznaczenia 3, 6, 9, 12
    turtle.circle(rozmiar)
    # rysujemy okrąg o promieniu równym wartości
    # zmiennej rozmiar
    turtle.setheading(90)
    # ustawiamy kierunek żółwia na wartość 90
    # ustawienie to powoduje, że żółw będzie zwrócony 
    # w górę
    turtle.penup()
    # podnosimy żółwia, od tej pory
    # poruszając się, nie pozostawia za
    # sobą śladu w postaci linii
    turtle.goto(x, y)
    # przemieszczamy żółwia do wskazanej pozycji
    # określonej przez zmienne x oraz y 
    turtle.pendown()
    # opuszczamy żółwia, od tej pory
    # poruszając się, pozostawia za
    # sobą ślad w postaci linii
    for _ in range(4):
        # pętla wykona się cztery razy
        turtle.penup()
        # podnosimy żółwia, od tej pory
        # poruszając się, nie pozostawia za
        # sobą śladu w postaci linii
        turtle.forward(0.8 * rozmiar)
        # przesuwamy żółwia o wartość zmiennej rozmiar
        # pomnożoną przez 0,8 do przodu
        turtle.pendown()
        # opuszczamy żółwia, od tej pory
        # poruszając się, pozostawia za
        # sobą ślad w postaci linii
        turtle.forward(0.2 * rozmiar)
        # przesuwamy żółwia o wartość zmiennej rozmiar
        # pomnożoną przez 0,2 do przodu
        turtle.penup()
        # podnosimy żółwia, od tej pory
        # poruszając się, nie pozostawia za
        # sobą śladu w postaci linii 
        turtle.backward(rozmiar)
        # przesuwamy żółwia o wartość zmiennej rozmiar do tyłu 
        turtle.pendown()
        # opuszczamy żółwia, od tej pory 
        # poruszając się, pozostawia za 
        # sobą ślad w postaci linii 
        turtle.right(90)
        # obracamy żółwia o 90 stopni w prawo

    # rysujemy wskazówkę sekund
    turtle.pencolor("red")
    # zmieniamy kolor linii, którą rysuje żółw, na czerwony 
    kat_sekundowa = 6 * sekundy
    # tworzymy zmienną kat_sekundowa
    # przypisujemy do niej wartość zmiennej sekundy
    # pomnożoną przez 6
    turtle.right(kat_sekundowa)
    # obracamy żółwia o wartość zmiennej kat_sekundy w prawo 
    turtle.forward(0.9 * rozmiar)
    # przesuwamy żółwia o wartość zmiennej rozmiar
    # pomnożoną przez 0,9 do przodu
    turtle.backward(0.9 * rozmiar)
    # przesuwamy żółwia o wartość zmiennej rozmiar
    # pomnożoną przez 0,9 do tyłu

    # rysujemy wskazówkę minut
    turtle.pensize(4)
    # ustawiamy rozmiar linii, którą rysuje żółw,
    # na wartość równą 4 piksele
    turtle.pencolor("blue")
    # zmieniamy kolor linii, którą rysuje żółw, na niebieski 
    turtle.setheading(90)
    # ustawiamy kierunek żółwia na wartość 90
    # ustawienie to powoduje, że żółw będzie zwrócony
    # w górę
    kat_minutowa = 6 * minuty + kat_sekundowa / 60
    # tworzymy zmienną o nazwie kat_minutowa
    # przypisujemy do niej wartość zmiennej minuty pomnożoną
    # przez 6 oraz wartość zmiennej kat_sekundowa podzieloną
    # przez 60
    turtle.right(kat_minutowa)
    # obracamy żółwia o wartość zmiennej kat_minutowa w prawo 
    turtle.forward(0.7 * rozmiar)
    # przesuwamy żółwia o wartość zmiennej rozmiar
    # pomnożoną przez 0,7 do przodu
    turtle.backward(0.7 * rozmiar)
    # przesuwamy żółwia o wartość zmiennej rozmiar
    # pomnożoną przez 0,7 do tyłu

    # rysujemy wskazówkę godzin
    turtle.pensize(6)
    # ustawiamy rozmiar linii, którą rysuje żółw,
    # na wartość równą 6 pikseli
    turtle.setheading(90)
    # ustawiamy kierunek żółwia na wartość 90
    # ustawienie to powoduje, że żółw będzie zwrócony
    # w górę
    kat_godzinowa = 30 * godziny + kat_minutowa / 12
    # tworzymy zmienną o nazwie kat_godzinowa
    # przypisujemy do niej wartość zmiennej godziny pomnożoną

    # przez 30 oraz wartość zmiennej kat_minutowa podzieloną
    # przez 12
    turtle.right(kat_godzinowa)
    # obracamy żółwia o wartość zmiennej kat_godzinowa w prawo 
    turtle.forward(0.5 * rozmiar)
    # przesuwamy żółwia o wartość zmiennej rozmiar 
    # pomnożoną przez 0,5 do przodu 
    turtle.backward(0.5 * rozmiar)
    # przesuwamy żółwia o wartość zmiennej rozmiar 
    # pomnożoną przez 0,5 do tyłu 
    turtle.hideturtle()
    # ukrywamy żółwia


def sekundy_na_godz_min_sec(sekundy):
    # tworzymy funkcję o nazwie sekundy_na_godz_min_sec
    # funkcja ta przyjmuje argument o nazwie sekundy
    # zadaniem tej funkcji jest zamiana sekund na godziny, minuty, sekundy 
    godz = sekundy // 3600
    # tworzymy zmienną godz i przypisujemy jej wartość
    # zmiennej sekundy podzielonej całkowicie przez 3600
    sekundy = sekundy % 3600
    # obliczamy resztę z dzielenia wartości zmiennej sekundy przez 3600
    # następnie wynik ten przypisujemy do zmiennej sekundy
    min = sekundy // 60
    # tworzymy zmienną min i przypisujemy jej wartość
    # zmiennej sekundy podzielonej całkowicie przez 60
    sekundy = sekundy % 60
    # obliczamy resztę z dzielenia wartości zmiennej sekundy przez 3600
    # następnie wynik ten przypisujemy do zmiennej sekundy
    return (godz, min, sekundy)
    # funkcja zwraca trzy zmienne spakowane jako krotka


def godz_min_sec_na_sekundy(godz, min, sek):
    # tworzymy funkcję o nazwie godz_min_sec_na_sekundy 
    # funkcja ta przyjmuje trzy argumenty
    # przelicza ona godzinę podaną jako trzy parametry
    # godz, min i sek na sekundy
    sekundy = (godz * 3600) + (min * 60) + sek
    # tworzymy zmienną o nazwie sekundy
    # zamieniamy wartość zmiennej godz oraz min
    # na liczbę sekund, następnie sumujemy to z wartością
    # zmiennej sek
    # całość przypisujemy do zmiennej sekundy
    return sekundy
    # zwracamy wartość zmiennej sekundy


def pobierz_aktualny_czas():
    # tworzymy funkcję o nazwie pobierz_aktalny_czas 
    aktualny_czas = datetime.datetime.now()
    # tworzymy zmienną o nazwie aktualny_czas
    # przypisujemy jej aktualną datę i godzinę 
    godziny = int(aktualny_czas.hour)
    # ze zmiennej aktualny_czas pobieramy wartość
    # godzin i przypisujemy ją do zmiennej godziny
    minuty = int(aktualny_czas.minute)
    # ze zmiennej aktualny_czas pobieramy wartość
    # minut i przypisujemy ją do zmiennej minuty
    sekundy = int(aktualny_czas.second)
    # ze zmiennej aktualny_czas pobieramy wartość
    # sekund i przypisujemy ją do zmiennej sekundy
    czas_w_sekundach = godz_min_sec_na_sekundy(godziny, minuty, sekundy)
    # wywołujemy funkcję zamieniającą godziny, minuty i sekundy
    # uzyskane wcześniej na całkowitą liczbę sekund
    # wartość ta jest zwracana i przypisywana do zmiennej czas_w_sekundach
    return czas_w_sekundach
    # funkcja zwraca wartość zmiennej czas_w_sekundach


sekundy = pobierz_aktualny_czas()


# wywołujemy funkcję pobierz_aktualny_czas
# funkcja ta zwraca aktualny czas jako liczbę sekund
# liczba ta jest przypisywana do zmiennej globalnej sekundy


def odmierzaj():
    # tworzymy funkcję odmierzaj
    # funkcja ta będzie wywoływała samą siebie co sekundę 
    global sekundy
    # rejestrujemy zmienną sekundy jako globalną
    if sekundy != pobierz_aktualny_czas():
        # sprawdzamy czas, jaki jest w zmiennej sekundy 
        # jest zgodny z aktualnym czasem w sekundach
        # jeśli tak nie jest, to do zmiennej sekundy
        # przypisujemy dokładny czas
        # dokonujemy tutaj synchronizacji czasu
        sekundy = pobierz_aktualny_czas()
    czas = sekundy_na_godz_min_sec(sekundy)
    # tworzymy zmienną czas i przypisujemy do niej wartość 
    # zwróconą przez funkcję sekundy_na_godz_min_sec
    # dla argumentu sekundy
    # zmienna czas jest trzyelementową krotką 
    zegar(czas[0], czas[1], czas[2], 200, 0, 0)
    # wywołujemy funkcję rysującą zegar
    sekundy = sekundy + 1
    # zwiększamy zmienną sekundy o 1 
    turtle.ontimer(odmierzaj, 1000)
    # wywołujemy funkcję odmierzaj za 1000 milisekund
    # czyli 1 sekundę


odmierzaj()
# wywołujemy funkcję odmierzaj


turtle.mainloop()
# zapobiegamy zamknięciu się okna 
# po zakończeniu rysowania
