import turtle


# importujemy moduł turtle


def kwadrat(x, y, a, wypelnienie):
    # tworzymy funkcję o nazwie kwadrat
    # funkcja ta przyjmuje cztery argumenty
    # pierwsze dwa to pozycja x, y środka kwadratu
    # trzeci argument określa wielkość boku figury
    # ostatni argument określa kolor wypełnienia kwadratu 
    turtle.penup()
    # podnosimy żółwia, od tej pory
    # poruszając się, nie pozostawia za
    # sobą śladu w postaci linii
    turtle.goto(x - (a / 2), y - (a / 2))
    # przemieszczamy żółwia do wskazanej pozycji
    # określonej przez zmienne x oraz y
    # od wartości x oraz y odejmowana jest
    # wartość połowy zmiennej a
    turtle.pendown()
    # opuszczamy żółwia, od tej pory
    # poruszając się, pozostawia za
    # sobą ślad w postaci linii 
    turtle.fillcolor(wypelnienie)
    # ustawiamy kolor wypełnienia
    # na wartość zmiennej o nazwie wypelnienie
    turtle.begin_fill()
    # rozpoczynamy wypełnianie 
    for _ in range(4):
        # pętla wykona się cztery razy
        turtle.forward(a)
        # przesuwamy żółwia o wartość zmiennej a do przodu 
        turtle.left(90)
        # obracamy żółwia o 90 stopni w lewo
    turtle.end_fill()
    # kończymy wypełnianie figury


def szachownica(x, y, n, rozmiar, kolory):
    # tworzymy funkcję o nazwie szachownica
    # funkcja ta przyjmuje pięć argumentów
    # pierwsze dwa określają pozycję lewego dolnego 
    # kwadracika, argument o nazwie rozmiar
    # określa liczbę kwadratów w jednym wierszu 
    # ostatni argument przyjmuje listę kolorów
    # lista ta pozwala na definiowanie kolorów
    # szachownicy
    for i in range(n):
        # pętla wykona się n razy
        # zmienna i przyjmie wartości od 0 do n–1 
        for j in range(n):
            # pętla wykona się n razy
            # zmienna j przyjmie wartości od 0 do n–1
            kwadrat(x + j * rozmiar, y + i * rozmiar, rozmiar, kolory[j % 2])
            # wywołujemy funkcję rysującą pojedynczy kwadrat
            # pozycja x oraz y zależy od wartości zmiennych i oraz j
            # kolor wypełnienia obliczany jest jako reszta z dzielenia
            # aktualnej wartości zmiennej j przez 2
            # wyrażenie j % 2 przyjmuje wartości na przemian 0 i 1
        kolory = kolory[::-1]
        # odwracamy listę kolory
        # zabieg ten jest podobny do tego, co 
        # zostało zrobione w kodzie rysującym 
        # szachownicę sił zbrojnych RP


szachownica(-275, -275, 12, 50, ["red", "white"])
# wywołujemy funkcję szachownica
# tak wywołana funkcja narysuje nam szachownicę
# współrzędne x i y zostały tak dobrane,
# aby szachownica została narysowana na środku 
# okna turtle
# szachownica będzie składać się z kwadratów
# na przemian czerwonych oraz białych


turtle.mainloop()
# zapobiegamy zamknięciu się okna 
# po zakończeniu rysowania
