;code by jasper/stc
.386
JUMPS
ASSUME	CS:CODE,SS:STACKS
CODE	SEGMENT USE16
ile_pix	equ 8			;ilosc punktow
ile_sci	equ 12			;ilosc scian
katx	dw 0			;\
katy	dw 0			; >katy obrotow wokol trzech osi
katz	dw 0			;/
dist	dw 6000			;odlegosc od obserwatora
d_x	dw 160			;korekcja X
d_y	dw 100			;korekcja Y
include	scianat.asm
Begin:
	mov	ax,0013h
	int	10h		;ustaw tryb 13h 320x200x256c
	mov	dx,seg pal	;\
	mov	ds,dx		; >ustaw
	lea	si,pal		; >palete
	call	Paleta		;/
Petla:
	call	Ramka		;kontrola ramki
	call	Przesun		;kopiuj dane do tablicy pomocniczej
	call	Rotates		;obracaj punkty
	call	Rysuj		;rysuj sciany
	call	Zmien		;zmien strony
	call	Czysc		;czysc bufor
	call	Z_katy		;uaktualnij katy
	mov	ah,01h
	int	16h
	jz 	petla		;czekaj na klawisz
	mov	ax,0003h
	int	10h		;ustaw tryb tekstowy
	mov	ax,4c00h
	int	21h		;wyjscie do DOSu
Ramka	PROC			;kontrola ramki
	mov	dx,3dah
Ram1:
	in	al,dx
	test	al,8		;sprawdz 3 bit portu 3dah
	jnz	ram1		;jezeli nie zero to skok
Ram2:
	in	al,dx
	test	al,8		;sprawdz 3 bit portu 3dah
	jz	ram2		;jezeli zero to skok
	ret
Ramka	ENDP
Paleta	PROC			;ustawianie palety DS:SI-zadana paleta
	mov	cx,256*3	;ustaw 256 kolorow
	mov	dx,3c8h
	mov	al,0		;zacznij od zerowego
	out	dx,al
	inc	dx
	cld
	rep	outsb		;wysylaj dane do portu
	ret
Paleta	ENDP
Przesun	PROC			;skopiuj dane do tablicy pomocniczej
        mov     dx,seg bryla
        mov     ds,dx		;z tablicy bryla
        lea     si,bryla
        mov     dx,seg wsp3d
        mov     es,dx		;do tablicy wsp3d
        lea     di,wsp3d
        mov     cx,ile_pix 
        mov     bx,cx 
        add     cx,bx 
        add     cx,bx 
        cld 
        rep     movsw		;kopiuj
        ret 
Przesun	ENDP
Rysuj	PROC
	mov	dx,seg wsp2d	
	mov	es,dx		;wspolrzedne wierzcholkow w tablicy wsp2d
	lea	di,wsp2d
	mov	dx,seg lacz
	mov	ds,dx		;dane o polaczeniach w tablicy lacz
	lea	si,lacz
	mov	cx,ile_sci/2	;rysuj ile_sci scian
Rys:
	push	cx
	mov	bx,ds:[si]	;wczytaj numer pierwszego wierzcholka
	shl	bx,2
	movsx	eax,word ptr es:[di][bx]	;wczytaj wspolrzedna x
	mov	x1,eax
	movsx	eax,word ptr es:[di][bx][2]	;wczytaj wspolrzedna y
	mov	y1,eax
	mov	bx,ds:[si][2]	;wczytaj numer drugiego wierzcholka
	shl	bx,2
	movsx	eax,word ptr es:[di][bx]	;wczytaj wspolrzedna x
	mov	x2,eax
	movsx	eax,word ptr es:[di][bx][2]	;wczytaj wspolrzedna y
	mov	y2,eax
	mov	bx,ds:[si][4]	;wczytaj numer trzeciego wierzcholka
	shl	bx,2
	movsx	eax,word ptr es:[di][bx]	;wczytaj wspolrzedna x
	mov	x3,eax
	movsx	eax,word ptr es:[di][bx][2]	;wczytaj wspolrzedna y
	mov	y3,eax
;sprawdz widocznosc sciany
	mov	ax,word ptr x1	;\
	sub	ax,word ptr x2	; >oblicz wartosc wyrazenia
	mov	bx,word ptr y3	; >(x1-x2)*(y3-y2)
	sub	bx,word ptr y2	;/
	imul	bx
	shl	edx,16
	mov	dx,ax
	push	edx
	mov	ax,word ptr x2	;\
	sub	ax,word ptr x3	; >oblicz wartosc wyrazenia
	mov	bx,word ptr y2	; >(x2-x3)*(y2-y1)
	sub	bx,word ptr y1	;/
	imul	bx
	shl	edx,16
	mov	dx,ax
	pop	ebx
	sub	ebx,edx		;oblicz (x1-x2)*(y3-y2)-(x2-x3)*(y2-y1)
	cmp	ebx,0		;porownaj to do zera
	jl	bezscia		;jezeli mniejsze to nie rysuj sciany
	push	ds
	push	es
	pusha
	mov	dx,seg bufor
	mov	es,dx		;rysuj w buforze
	mov	xt1,0		;\
	mov	yt1,0		; \
	mov	xt2,127		;  >przyporzadkuj wierzcholkom
	mov	yt2,0		;  >wspolrzedne tekstury
	mov	xt3,127		; /
	mov	yt3,127		;/
	call	Scianat		;rysuj sciane
	popa
	pop	es
	pop	ds
	mov	bx,ds:[si][8]	;wczytaj numer pierwszego wierzcholka
	shl	bx,2
	movsx	eax,word ptr es:[di][bx]	;wczytaj wspolrzedna x
	mov	x1,eax
	movsx	eax,word ptr es:[di][bx][2]	;wczytaj wspolrzedna y
	mov	y1,eax
	mov	bx,ds:[si][10]	;wczytaj numer drugiego wierzcholka
	shl	bx,2
	movsx	eax,word ptr es:[di][bx]	;wczytaj wspolrzedna x
	mov	x2,eax
	movsx	eax,word ptr es:[di][bx][2]	;wczytaj wspolrzedna y
	mov	y2,eax
	mov	bx,ds:[si][12]	;wczytaj numer trzeciego wierzcholka
	shl	bx,2
	movsx	eax,word ptr es:[di][bx]	;wczytaj wspolrzedna x
	mov	x3,eax
	movsx	eax,word ptr es:[di][bx][2]	;wczytaj wspolrzedna y
	mov	y3,eax
	push	ds
	push	es
	pusha
	mov	dx,seg bufor
	mov	es,dx		;rysuj w buforze
	mov	xt1,127		;\
	mov	yt1,127		; \
	mov	xt2,0		;  >przyporzadkuj wierzcholkom
	mov	yt2,127		;  >wspolrzedne tekstury
	mov	xt3,0		; /
	mov	yt3,0		;/
	call	Scianat		;rysuj sciane
	popa
	pop	es
	pop	ds
Bezscia:
	add	si,16
	pop	cx
	loop	rys
	ret
Rysuj	ENDP
Zmien	PROC			;kopiuj zawartosc bufora na ekran  
	mov	dx,seg bufor
	mov	ds,dx		;czytaj z bufora
	mov	si,0
	mov	dx,0a000h
	mov	es,dx		;zapisuj na ekran
	mov	di,0
	mov	eax,0
	mov	cx,64000/4	;64000 bajty
	cld
	rep	movsd		;kopiuj
	ret
Zmien	ENDP
Czysc	PROC			;czysc bufor
	mov	dx,seg bufor
	mov	es,dx
	mov	di,0
	mov	eax,0		;czysc kolorem zerowym
	mov	cx,64000/4	;bufor ma dlugosc 64000 bajtow
	rep	stosd		;czysc
	ret
Czysc	ENDP
Z_katy	PROC			;uaktualnij katy
	add	katx,1		;kat obrotu wokol osi OX
	cmp	katx,360
	jb	okx
	mov	katx,0
Okx:
	add	katy,1		;OY
	cmp	katy,360
	jb	oky
	mov	katy,0
Oky:
	add	katz,1		;OZ
	cmp	katz,360
	jb	okz
	mov	katz,0
Okz:
	ret
Z_katy	ENDP
include 3d_math.inc		;dolacz procedury na obroty i perspektywe
include sinus.inc		;dolacz tablice sinusow
include cosinus.inc		;i cosinusow

;tablica polaczen
lacz	dw 0,1,2,1,  2,3,0,1,  7,6,5,1,  5,4,7,1,  1,5,6,2,  6,2,1,2
	dw 4,0,3,2,  3,7,4,2,  1,0,4,3,  4,5,1,3,  2,6,7,3,  7,3,2,3
;tablica wspolrzednych wierzcholkow bryly
bryla	dw -1000,-1000, 1000,	 1000,-1000, 1000
	dw  1000, 1000, 1000,	-1000, 1000, 1000
	dw -1000,-1000,-1000,	 1000,-1000,-1000
	dw  1000, 1000,-1000,	-1000, 1000,-1000
Sciana:
include sciana.tab		;dolacz teksture
Pal:
include sciana.pal		;i jej palete
CODE	ENDS

BUF	SEGMENT USE16
Bufor dw 32000 dup(0)		;zdefiniuj bufor
BUF	ENDS

STACKS	SEGMENT USE16 STACK 'STACK'
db 512	dup(0)			;i stos
STACKS	ENDS

END	Begin
