;code by jasper/stc
JUMPS
.386C
ASSUME	cs:CODE,ss:STACKS

CODE SEGMENT USE16
ile_pix	equ 2500		;ilosc punktow
xr	dw 0			;\
yr	dw 0			; >zmienne pomocnicze
zr	dw 0			;/
obsY	dw 300			;wspolrzedna Y obserwatora
d_x	dw 160			;korekcja X
d_y	dw -100			;korekcja Y
dist	dw 800			;odleglosc od obserwatora
poz	dw 0			;pozycja we fractalu

Begin:
	mov	ax,0013h
	int	10h		;ustaw tryb 13h 320x200x256c
	mov	dx,seg fractpal	;\
	mov	ds,dx		; >ustaw
	lea	si,fractpal	; >palete
	call	Paleta		;/
Petla1:
	call	Ramka		;kontrola ramki
	call	Przesun		;przesun dane do tablicy pomocniczej
	call	Pers		;oblicz perspektywe
	call	Rysuj		;rysuj punkty
	call	Zmien		;zmien strone
	call	Czysc		;czysc ekran
	add	poz,321
	cmp	poz,321*150
	je	petla2
	mov	ah,01h		;\
	int	16h		; >czekaj na klawisz
	jnz	koniec		;/
	jmp	petla1
Petla2:
	call	Ramka		;kontrola ramki
	call	Przesun		;przesun dane do tablicy pomocniczej
	call	Pers		;oblicz perspektywe
	call	Rysuj		;rysuj punkty
	call	Zmien		;zmien strone
	call	Czysc		;czysc ekran
	sub	poz,320
	cmp	poz,150
	je	petla3
	mov	ah,01h		;\
	int	16h		; >czekaj na klawisz
	jnz	koniec		;/
	jmp	petla2
Petla3:
	call	Ramka		;kontrola ramki
	call	Przesun		;przesun dane do tablicy pomocniczej
	call	Pers		;oblicz perspektywe
	call	Rysuj		;rysuj punkty
	call	Zmien		;zmien strone
	call	Czysc		;czysc ekran
	add	poz,319
	cmp	poz,320*150
	je	petla4
	mov	ah,01h		;\
	int	16h		; >czekaj na klawisz
	jnz	koniec		;/
	jmp	petla3
Petla4:
	call	Ramka		;kontrola ramki
	call	Przesun		;przesun dane do tablicy pomocniczej
	call	Pers		;oblicz perspektywe
	call	Rysuj		;rysuj punkty
	call	Zmien		;zmien strone
	call	Czysc		;czysc ekran
	sub	poz,320
	cmp	poz,0
	je	petla1
	mov	ah,01h		;\
	int	16h		; >czekaj na klawisz
	jnz	koniec		;/
	jmp	petla4
Koniec:
	mov	ax,0003h
	int	10h		;ustaw tryb tekstowy
	mov	ax,4c00h
	int	21h		;powrot do DOSu

Rysuj	PROC
	mov	dx,seg wsp2d	;\
	mov	ds,dx		; >wspolrzedne punktow w tablicy wsp2d
	lea	si,wsp2d	;/
	mov	dx,seg bufor
	mov	es,dx		;rysuj w buforze
	mov	dx,seg ofs	;\
	mov	fs,dx		; >tu zapamietaj offsety punktow
	lea	bp,ofs		;/
	mov	cx,ile_pix	;rysuj ile_pix punktow
	mov	dx,seg kol	;\
	mov	gs,dx		; >kolory punktow
	lea	bx,kol		;/
Rys:
	mov	di,ds:[si]	;wspolrzedna X
	mov	ax,ds:[si][2]	;wspolrzedna Y
	cmp	di,0		;\
	jl	Niemapix	; \
	cmp	di,319		;  \
	jg	Niemapix	;   >sprawdz czy punkt nie
	cmp	ax,0		;   >wychodzi poza ekran
	jl	Niemapix	;  /
	cmp	ax,199		; /
	jg	Niemapix	;/
	xchg	ah,al		;\
	add	di,ax		; >oblicz
	shr	ax,2		; >320*y+x
	add	di,ax		;/
	mov	al,gs:[bx]	;kolor punktu
	mov	es:[di],al	;postaw punkt
	mov	fs:[bp],di	;i zapisz jego offset
Niemapix:
	add	bp,2
	add	si,4
	inc	bx
	loop	rys		;nastepny punkt
        ret
Rysuj	ENDP
Zmien	PROC			;kopiuj zawartosc bufora na ekran  
	mov	dx,seg bufor
	mov	ds,dx		;czytaj z bufora
	mov	si,0
	mov	dx,0a000h
	mov	es,dx		;zapisuj na ekran
	mov	di,0
	mov	eax,0
	mov	cx,64000/4	;64000 bajty
	cld
	rep	movsd		;kopiuj
	ret
Zmien	ENDP
Czysc	PROC			;czysc bufor ekranu
	mov	dx,seg bufor
	mov	es,dx
	mov	dx,seg ofs	;offsety sa w tablicy ofs
	mov	ds,dx
	lea	si,ofs
	mov	eax,0
	mov	cx,ile_pix	;wyczysc ile_pix punktow
Cz:
	lodsw
	mov	es:[eax],byte ptr 0	;czysc punkt
	loop	cz
	ret
Czysc	ENDP
Ramka	PROC			;kontrola ramki
	mov	dx,3dah
Ram1:
	in	al,dx
	test	al,8		;sprawdz 3 bit portu 3dah
	jnz	ram1		;jezeli nie zero to skok
Ram2:
	in	al,dx
	test	al,8		;sprawdz 3 bit portu 3dah
	jz	ram2		;jezeli zero to skok
	ret
Ramka	ENDP
Przesun	PROC			;skopiuj dane do tablicy pomocniczej
        mov     dx,seg bryla
        mov     ds,dx		;z tablicy bryla
        lea     si,bryla
        mov     dx,seg wsp3d
        mov     es,dx		;do tablicy wsp3d
        lea     di,wsp3d
        mov     cx,ile_pix 
        mov     bx,cx 
        add     cx,bx 
        add     cx,bx 
        cld 
        rep     movsw		;kopiuj

;odczytaj kolory 2500 punktow i zapisz je w oddzielnej tablicy
	mov	dx,seg fractal	;\
	mov	ds,dx		; >czytaj z tablicy fractal
	lea	si,fractal	;/
	add	si,poz		;dodaj pozycje we fractalu
	mov	dx,seg kol	;\
	mov	es,dx		; >zapisuj do tablicy kol
	lea	di,kol		;/
	mov 	dx,50		;wysokosc 50 punktow
Przes:
	mov	cx,50		;szerokosc 50 punktow
	rep	movsb		;kopiuj
	add	si,270		;nastepna linia
	dec	dx
	jnz	przes
        ret 
Przesun	ENDP
Pers	PROC			;obliczanie perspektywy
	mov	cx,ile_pix	;obliczenia dla ile_pix punktow
	mov	dx,seg wsp3d
	mov	ds,dx		;czytaj z tablicy wsp3d
	lea	si,wsp3d
	mov	dx,seg wsp2d
	mov	es,dx		;zapisuj do tablicy wsp2d
	lea	di,wsp2d
	mov	dx,seg kol
	mov 	fs,dx		;tablica z kolorami punktow
	lea	bp,kol
Obroc:
;Perspektywa
	mov	bx,ds:[si][4]	;wczytaj wspolrzedna Z
	add	bx,dist		;dodaj odleglosc od obserwatora
;wspolrzedna X
	mov	ax,ds:[si]	;wczytaj wspolrzedna X
	movsx	dx,ah
	shl	ax,8		;pomnoz przez 256
	idiv	bx		;podziel przez Z+Dist
	add	ax,d_x		;korekcja X
	stosw
;wspolrzedna Y
	xor	ax,ax
	mov	al,fs:[bp]
	neg	al
	shl	ax,2
	add	ax,ds:[si][2]	;wczytaj wspolrzedna Y
	add	ax,obsY
	movsx	dx,ah
	shl	ax,8		;pomnoz przez 256
	idiv	bx		;podziel przez Z+Dist
	add	ax,d_y		;korekcja Y
	stosw
        add     si,6
	inc	bp
	loop	obroc		;powtarzaj ile_pix razy
        ret
Pers	ENDP
Paleta	PROC			;ustawianie palety DS:SI-rzadana paleta
	mov	cx,256*3	;ustaw 256 kolorow
	mov	dx,3c8h
	mov	al,0		;zacznij od zerowego
	out	dx,al
	inc	dx
	cld
	rep	outsb		;wysylaj dane do portu
	ret
Paleta	ENDP

wsp2d	dw ile_pix dup(0,0)	;tablica na wspolrzedne 2d
wsp3d	dw ile_pix dup(0,0,0)	;tablica na wspolrzedne 3d
Bryla:
include punkty.inc		;dolacz wspolrzedne punktow
ofs	dw ile_pix dup(0)	;tablica na offsety punktow
kol	dw ile_pix dup(0)	;tablica na kolory punktow
CODE	ENDS

BUF	SEGMENT USE16
Bufor	dw 32000 dup(0)		;zdefiniuj bufor
BUF	ENDS

FRACT	SEGMENT USE16
Fractal:
include fractal.inc		;dolacz fractala
Fractpal:
include fractal.pal		;i jego palete
FRACT	ENDS

STACKS	SEGMENT PARA USE16 STACK 'STACK'
db 512	dup (0)			;zdefiniuj stos
STACKS	ENDS

END	Begin
