package prose

import "testing"

type testData struct {
	list []string
	want string
}

func TestJoinWithCommas(t *testing.T) {
	tests := []testData{
		testData{list: []string{}, want: ""},
		testData{list: []string{"jabłko"}, want: "jabłko"},
		testData{list: []string{"jabłko", "pomarańcza"}, want: "jabłko i pomarańcza"},
		testData{list: []string{"jabłko", "pomarańcza", "gruszka"}, want: "jabłko, pomarańcza, a także gruszka"},
	}
	for _, test := range tests {
		got := JoinWithCommas(test.list)
		if got != test.want {
			t.Errorf("JoinWithCommas(%#v) = \"%s\", want \"%s\"", test.list, got, test.want)
		}
	}
}
