// Program pass_fail informuje o tym, czy dany wynik oznacza zaliczenie testu.
package main

import (
	"bufio"
	"fmt"
	"log"
	"os"
	"strconv"
	"strings"
)

func main() {
	fmt.Print("Podaj wynik: ")
	reader := bufio.NewReader(os.Stdin)
	input, err := reader.ReadString('\n')
	if err != nil {
		log.Fatal(err)
	}

	input = strings.TrimSpace(input)
	grade, err := strconv.ParseFloat(input, 64)
	if err != nil {
		log.Fatal(err)
	}

	var status string
	if grade >= 60 {
		status = "zaliczenie"
	} else {
		status = "brak zaliczenia"
	}
	fmt.Println("Wynik", grade, "oznacza", status, ".")
}
