package main

import "fmt"

type Whistle string

func (w Whistle) MakeSound() {
	fmt.Println("Fiu!")
}

type Horn string

func (h Horn) MakeSound() {
	fmt.Println("Bip!")
}

type Robot string

func (r Robot) MakeSound() {
	fmt.Println("Bibop")
}
func (r Robot) Walk() {
	fmt.Println("Uruchamiam nogi")
}

type NoiseMaker interface {
	MakeSound()
}

func play(n NoiseMaker) {
	n.MakeSound()
	// Walk nie jest częścią interfejsu NoiseMaker.
	// Przeniesienie następnego wiersza poza komentarz spowoduje błąd kompilacji!
	// n.Walk()
}

func main() {
	var toy NoiseMaker
	toy = Whistle("Gwizdałek")
	toy.MakeSound()
	toy = Horn("Postrach ulic")
	toy.MakeSound()
	play(Robot("Elektrołazik"))
}
