package main

import (
	"fmt"
	"log"
)

func paintNeeded(width float64, height float64) (float64, error) {
	if width < 0 {
		return 0, fmt.Errorf("Szerokość %0.2f jest nieprawidłowa.", width)
	}
	if height < 0 {
		return 0, fmt.Errorf("Wysokość %0.2f jest nieprawidłowa.", height)
	}
	area := width * height
	return area / 10.0, nil
}

func main() {
	amount, err := paintNeeded(5.2, 3.5)
	if err != nil {
		log.Fatal(err)
	}
	fmt.Printf("Potrzebnych litrów: %0.2f.\n", amount)
	amount, err = paintNeeded(4.2, -3.0)
	if err != nil {
		log.Fatal(err)
	}
	fmt.Printf("Potrzebnych litrów: %0.2f.\n", amount)
}
