package main

import (
	"bufio"
	"fmt"
	"html/template"
	"log"
	"net/http"
	"os"
)

// Guestbook to struktura używana do wyświetlania pliku view.html.
type Guestbook struct {
	SignatureCount int
	Signatures     []string
}

// Gdy wartość błędu jest różna od nil, funkcja check wywołuje funkcję log.Fatal.
func check(err error) {
	if err != nil {
		log.Fatal(err)
	}
}

// Funkcja viewHandler wczytuje wpisy z księgi gości i wyświetla je
// rezem z liczbą wszystkich wpisów.
func viewHandler(writer http.ResponseWriter, request *http.Request) {
	signatures := getStrings("signatures.txt")
	html, err := template.ParseFiles("view.html")
	check(err)
	guestbook := Guestbook{
		SignatureCount: len(signatures),
		Signatures:     signatures,
	}
	err = html.Execute(writer, guestbook)
	check(err)
}

// newHandler wyświetla formularz do wprowadzania wpisów.
func newHandler(writer http.ResponseWriter, request *http.Request) {
	html, err := template.ParseFiles("new.html")
	check(err)
	err = html.Execute(writer, nil)
	check(err)
}

// createHandler przyjmuje żądanie POST z dodawanym wpisem i dołącza
// go do pliku z wpisami.
func createHandler(writer http.ResponseWriter, request *http.Request) {
	signature := request.FormValue("signature")
	options := os.O_WRONLY | os.O_APPEND | os.O_CREATE
	file, err := os.OpenFile("signatures.txt", options, os.FileMode(0600))
	check(err)
	_, err = fmt.Fprintln(file, signature)
	check(err)
	err = file.Close()
	check(err)
	http.Redirect(writer, request, "/guestbook", http.StatusFound)
}

// getStrings zwraca wycinek łańcuchów znaków wczytanych z pliku o nazwie
// z parametru fileName. Każdy łańcuch znaków to jeden wiersz z pliku.
func getStrings(fileName string) []string {
	var lines []string
	file, err := os.Open(fileName)
	if os.IsNotExist(err) {
		return nil
	}
	check(err)
	defer file.Close()
	scanner := bufio.NewScanner(file)
	for scanner.Scan() {
		lines = append(lines, scanner.Text())
	}
	check(scanner.Err())
	return lines
}

func main() {
	http.HandleFunc("/guestbook", viewHandler)
	http.HandleFunc("/guestbook/new", newHandler)
	http.HandleFunc("/guestbook/create", createHandler)
	err := http.ListenAndServe("localhost:8080", nil)
	log.Fatal(err)
}
