// Copyright 2010, Mark C. Chu-Carroll (markcc@gmail.com).
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.pragprog.aebook.persistchat.client;

import java.util.Date;
import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.pragprog.aebook.persistchat.ChatRoom;
import com.pragprog.aebook.persistchat.ChatMessage;
import com.pragprog.aebook.persistchat.ChatMessageList;

//START: main
public interface ChatSubmissionServiceAsync {
    
//START: Fetches
    void  postMessage(ChatMessage message, 
			AsyncCallback<Void> callback);
	  
	void getMessages(String chatroom, 
			AsyncCallback<ChatMessageList> callback);	

	void getMessagesSince(String chat, Date timestamp,
			AsyncCallback<ChatMessageList> callback);
//END: Fetches

//START: ChatMethods
	void getChats(AsyncCallback<List<ChatRoom>> chats);

    void addChat(String chatname,
            AsyncCallback<Void> callback);
//END: ChatMethods
}
//END: main
