// Copyright 2010, Mark C. Chu-Carroll (markcc@gmail.com).
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.pragprog.aebook.persistchat.client;

import java.util.Date;
import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.pragprog.aebook.persistchat.ChatRoom;
import com.pragprog.aebook.persistchat.ChatMessage;
import com.pragprog.aebook.persistchat.ChatMessageList;

//START: main
@RemoteServiceRelativePath("chat")
public interface ChatSubmissionService extends RemoteService {

//START: Fetches
    void postMessage(ChatMessage messages);//<callout id="co.post-void"/>
  
    ChatMessageList getMessages(String room);//<callout id="co.get-orig"/>
  
    ChatMessageList getMessagesSince(String chat, Date timestamp);//<callout id="co.get-since"/>
//END: Fetches
  
//START: ChatMethods
    List<ChatRoom> getChats();
  
    void addChat(String chatname);
//END: ChatMethods
}
//END: main