﻿# -*- coding: utf-8 -*-
from google.appengine.ext import db
from google.appengine.api import users
from google.appengine.ext import webapp
from google.appengine.ext.webapp import template
from google.appengine.ext.webapp.util import run_wsgi_app
import datetime
import os



#START: ChatMessage
class ChatMessage(db.Model):
    user = db.StringProperty(required=True)
    timestamp = db.DateTimeProperty(auto_now_add=True)
    message = db.TextProperty(required=True)
    chat = db.StringProperty(required=True)

CHATS = ['main', 'book', 'flame' ]
#KONIEC: ChatMessage

#START: RenderPage
class ChatRoomPage(webapp.RequestHandler):
  def get(self):
    user = users.get_current_user()
    if user is None: 
      self.redirect(users.create_login_url(self.request.uri))
    else:
      self.response.headers["Content-Type"] = "text/html charset=UTF-8"
      messages = db.GqlQuery("SELECT * From ChatMessage ORDER BY timestamp")
      template_values = {
        'title': "Witryna Chatu MarkCC w App Engine",
        'msg_list': messages,
        }
      path = os.path.join(os.path.dirname(__file__), 'chat-template.html')
      page = template.render(path, template_values) 
      self.response.out.write(page)
#KONIEC: RenderPage


#START: ChatRoomPoster
class ChatRoomPoster(webapp.RequestHandler):
  def post(self):
    user = users.get_current_user()
    msgtext = self.request.get("message")
    msg = ChatMessage(user=user.nickname(), message=msgtext, chat="chat")
    msg.put() 
    # Po dodaniu wiadomości do czatu, przekierujemy go
    # na naszą stronę główną,
    self.redirect('/')
#KONIEC: ChatRoomPoster

# START: Frame
chatapp = webapp.WSGIApplication([('/', ChatRoomPage),
                                  ('/talk', ChatRoomPoster)])
# KONIEC: Frame
def main():
    run_wsgi_app(chatapp)

if __name__ == "__main__":
    main()



