/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.Log2;
import com.google.appengine.repackaged.com.google.common.base.Log2FileHandler;
import com.google.appengine.repackaged.com.google.common.base.Log2Formatter;
import com.google.appengine.repackaged.com.google.common.base.LogContext;
import com.google.appengine.repackaged.com.google.common.base.Logger;
import com.google.common.annotations.GoogleInternal;
import java.text.DateFormat;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

@Deprecated
@GoogleInternal
public final class Log2Logger
implements Logger {
    private int threshold;
    private static final java.util.logging.Logger LOG = java.util.logging.Logger.getLogger("com.google.appengine.repackaged.com.google.common.base.Log2");
    private static boolean selfInstalledHandler = false;
    private static boolean useRootHandler = false;

    Log2Logger() {
        Handler[] handlers = LOG.getHandlers();
        if (handlers.length == 0 && !useRootHandler) {
            ConsoleHandler ch = new ConsoleHandler();
            ch.setFormatter(new Log2Formatter());
            this.addHandler(ch);
            this.setThreshold(0);
        }
    }

    Log2Logger(String filePath, String linkName, String extension, DateFormat recordTsFormat, DateFormat fileNameTsFormat, long rotateSize) {
        Handler[] handlers = LOG.getHandlers();
        if ((handlers.length == 0 || selfInstalledHandler) && !useRootHandler) {
            if (selfInstalledHandler) {
                LOG.removeHandler(handlers[0]);
            }
            Log2FileHandler h = new Log2FileHandler(filePath, linkName, extension, recordTsFormat, fileNameTsFormat, rotateSize);
            this.addHandler(h);
            this.setThreshold(0);
        }
    }

    public static void useRootHandler() {
        if (!useRootHandler) {
            Handler[] handlers = LOG.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                LOG.removeHandler(handlers[i]);
            }
            LOG.setUseParentHandlers(true);
            useRootHandler = true;
        }
    }

    public void setThreshold(int level) {
        Level javaLevel;
        if (level == 2) {
            javaLevel = Level.WARNING;
        } else if (level == 1) {
            javaLevel = Level.INFO;
        } else if (level == 0) {
            javaLevel = Level.FINEST;
        } else {
            throw new RuntimeException("Invalid level passed to Log2Logger.setThreshold ");
        }
        LOG.setLevel(javaLevel);
        if (selfInstalledHandler) {
            Handler[] handlers = LOG.getHandlers();
            handlers[0].setLevel(javaLevel);
        }
        this.threshold = level;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void logDebug(String msg) {
        if (LOG.isLoggable(Level.FINE)) {
            this.logAfterSettingCaller(Level.FINE, msg);
        }
    }

    public void logEvent(String msg) {
        if (LOG.isLoggable(Level.INFO)) {
            LogRecord lr = new LogRecord(Level.INFO, msg);
            this.doCallerInference(lr);
            LOG.log(lr);
        }
    }

    public void logTimedEvent(String msg, long start, long end) {
        LOG.info(end - start + " ms.: " + msg);
    }

    public void setErrorEmail(String emailAddr) {
    }

    public void logException(Throwable t) {
        this.logException(t, "");
    }

    public void logException(Throwable t, String msg) {
        if (LOG.isLoggable(Level.WARNING)) {
            this.logAfterSettingCaller(Level.WARNING, msg, t);
        }
    }

    public void logSevereException(Throwable t) {
        this.logSevereException(t, "");
    }

    public void logSevereException(Throwable t, String msg) {
        if (LOG.isLoggable(Level.SEVERE)) {
            this.logAfterSettingCaller(Level.SEVERE, msg, t);
        }
    }

    public void logError(String msg) {
        this.logAfterSettingCaller(Level.WARNING, msg + "\n" + Log2.getExceptionTrace(new LoggedError()));
    }

    public String getThreadTag() {
        return LogContext.getThreadTag();
    }

    public void setThreadTag(String s) {
        LogContext.setThreadTag(s);
    }

    public void close() {
        Handler[] handlers = LOG.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].close();
        }
    }

    private void addHandler(Handler handler) {
        LOG.addHandler(handler);
        boolean useParentHandlers = false;
        String val = LogManager.getLogManager().getProperty(LOG.getName() + ".useParentHandlers");
        String string = val = val == null ? "" : val.toLowerCase();
        if (val.equals("true") || val.equals("1")) {
            useParentHandlers = true;
        }
        LOG.setUseParentHandlers(useParentHandlers);
        selfInstalledHandler = true;
    }

    private void doCallerInference(LogRecord record) {
        String loggerClassName = Log2.class.getName();
        StackTraceElement[] callStack = new Throwable().getStackTrace();
        int lastLoggerCallIndex = Integer.MAX_VALUE;
        for (int i = 0; i < callStack.length; ++i) {
            String className = callStack[i].getClassName();
            if (className.equals(loggerClassName)) {
                lastLoggerCallIndex = i;
                continue;
            }
            if (lastLoggerCallIndex == Integer.MAX_VALUE) continue;
            record.setSourceClassName(callStack[i].getClassName());
            record.setSourceMethodName(callStack[i].getMethodName());
            break;
        }
    }

    private void logAfterSettingCaller(Level level, String msg, Throwable t) {
        LogRecord lr = new LogRecord(level, msg);
        if (t != null) {
            lr.setThrown(t);
        }
        this.doCallerInference(lr);
        LOG.log(lr);
    }

    private void logAfterSettingCaller(Level level, String msg) {
        this.logAfterSettingCaller(level, msg, null);
    }

    private static class LoggedError
    extends Throwable {
        private static final long serialVersionUID = 1L;

        private LoggedError() {
        }
    }
}

