/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.users;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFailureException;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.UserServicePb;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UserServiceImpl
implements UserService {
    static final String USER_ID_KEY = "com.google.appengine.api.users.UserService.user_id_key";
    static final String FEDERATED_IDENTITY_KEY = "com.google.appengine.api.users.UserService.federated_identity";
    static final String FEDERATED_AUTHORITY_KEY = "com.google.appengine.api.users.UserService.federated_authority";
    static final String IS_FEDERATED_USER_KEY = "com.google.appengine.api.users.UserService.is_federated_user";
    private static final String PACKAGE = "user";
    private static final String LOGIN_URL_METHOD = "CreateLoginURL";
    private static final String LOGOUT_URL_METHOD = "CreateLogoutURL";

    UserServiceImpl() {
    }

    @Override
    public String createLoginURL(String destinationURL) {
        return this.createLoginURL(destinationURL, null, null, null);
    }

    @Override
    public String createLoginURL(String destinationURL, String authDomain) {
        return this.createLoginURL(destinationURL, authDomain, null, null);
    }

    @Override
    public String createLoginURL(String destinationURL, String authDomain, String federatedIdentity, Set<String> attributesRequest) {
        UserServicePb.CreateLoginURLRequest request = new UserServicePb.CreateLoginURLRequest();
        request.setDestinationUrl(destinationURL);
        if (authDomain != null) {
            request.setAuthDomain(authDomain);
        }
        if (federatedIdentity != null) {
            request.setFederatedIdentity(federatedIdentity);
        }
        byte[] responseBytes = this.makeSyncCall(LOGIN_URL_METHOD, request, destinationURL);
        UserServicePb.CreateLoginURLResponse response = new UserServicePb.CreateLoginURLResponse();
        response.mergeFrom(responseBytes);
        return response.getLoginUrl();
    }

    @Override
    public String createLogoutURL(String destinationURL) {
        return this.createLogoutURL(destinationURL, null);
    }

    @Override
    public String createLogoutURL(String destinationURL, String authDomain) {
        UserServicePb.CreateLogoutURLRequest request = new UserServicePb.CreateLogoutURLRequest();
        request.setDestinationUrl(destinationURL);
        if (authDomain != null) {
            request.setAuthDomain(authDomain);
        }
        byte[] responseBytes = this.makeSyncCall(LOGOUT_URL_METHOD, request, destinationURL);
        UserServicePb.CreateLogoutURLResponse response = new UserServicePb.CreateLogoutURLResponse();
        response.mergeFrom(responseBytes);
        return response.getLogoutUrl();
    }

    @Override
    public boolean isUserLoggedIn() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        return environment.isLoggedIn();
    }

    @Override
    public boolean isUserAdmin() {
        if (this.isUserLoggedIn()) {
            return ApiProxy.getCurrentEnvironment().isAdmin();
        }
        throw new IllegalStateException("The current user is not logged in.");
    }

    @Override
    public User getCurrentUser() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (!environment.isLoggedIn()) {
            return null;
        }
        String userId = (String)environment.getAttributes().get(USER_ID_KEY);
        Boolean isFederated = (Boolean)environment.getAttributes().get(IS_FEDERATED_USER_KEY);
        if (isFederated == null || !isFederated.booleanValue()) {
            return new User(environment.getEmail(), environment.getAuthDomain(), userId);
        }
        return new User(environment.getEmail(), (String)environment.getAttributes().get(FEDERATED_AUTHORITY_KEY), userId, (String)environment.getAttributes().get(FEDERATED_IDENTITY_KEY));
    }

    private byte[] makeSyncCall(String methodName, ProtocolMessage request, String destinationURL) {
        byte[] responseBytes;
        try {
            byte[] requestBytes = request.toByteArray();
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, methodName, requestBytes);
        }
        catch (ApiProxy.ApplicationException ex) {
            UserServicePb.UserServiceError.ErrorCode errorCode = UserServicePb.UserServiceError.ErrorCode.valueOf(ex.getApplicationError());
            switch (errorCode) {
                case REDIRECT_URL_TOO_LONG: {
                    throw new IllegalArgumentException("URL too long: " + destinationURL);
                }
                case NOT_ALLOWED: {
                    throw new IllegalArgumentException("The requested URL was not allowed: " + destinationURL);
                }
            }
            throw new UserServiceFailureException(ex.getErrorDetail());
        }
        return responseBytes;
    }
}

