/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.NormalizedQuery;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import java.util.Set;

class ValidatedQuery
extends NormalizedQuery {
    static final Set<DatastorePb.Query.Filter.Operator> UNSUPPORTED_OPERATORS = ValidatedQuery.makeImmutableSet(DatastorePb.Query.Filter.Operator.IN);

    ValidatedQuery(DatastorePb.Query query) {
        super(query);
        this.validateQuery();
    }

    private void validateQuery() {
        if (this.query.hasTransaction() && !this.query.hasAncestor()) {
            throw new IllegalQueryException("Only ancestor queries are allowed inside transactions.", IllegalQueryType.TRANSACTION_REQUIRES_ANCESTOR);
        }
        if (!this.query.hasKind()) {
            for (DatastorePb.Query.Filter filter : this.query.filters()) {
                if (filter.getProperty(0).getName().equals("__key__")) continue;
                throw new IllegalQueryException("kind is required for non-__key__ filters", IllegalQueryType.KIND_REQUIRED);
            }
            for (DatastorePb.Query.Order order : this.query.orders()) {
                if (order.getProperty().equals("__key__") && order.getDirection() == DatastorePb.Query.Order.Direction.ASCENDING.getValue()) continue;
                throw new IllegalQueryException("kind is required for all orders except __key__ ascending", IllegalQueryType.KIND_REQUIRED);
            }
        }
        String ineqProp = null;
        for (DatastorePb.Query.Filter filter : this.query.filters()) {
            int numProps = filter.propertySize();
            if (numProps != 1) {
                throw new IllegalQueryException(String.format("Filter has %s properties, expected 1", numProps), IllegalQueryType.FILTER_WITH_MULTIPLE_PROPS);
            }
            String propName = filter.getProperty(0).getName();
            if (INEQUALITY_OPERATORS.contains(filter.getOpEnum())) {
                if (ineqProp == null) {
                    ineqProp = propName;
                    continue;
                }
                if (ineqProp.equals(propName)) continue;
                throw new IllegalQueryException(String.format("Only one inequality filter per query is supported.  Encountered both %s and %s", ineqProp, propName), IllegalQueryType.MULTIPLE_INEQ_FILTERS);
            }
            if (!UNSUPPORTED_OPERATORS.contains(filter.getOpEnum())) continue;
            throw new IllegalQueryException(String.format("Unsupported filter operator: %s", filter.getOp()), IllegalQueryType.UNSUPPORTED_FILTER);
        }
        if (ineqProp != null && this.query.orderSize() > 0 && !ineqProp.equals(this.query.getOrder(0).getProperty())) {
            throw new IllegalQueryException(String.format("The first sort property must be the same as the property to which the inequality filter is applied.  In your query the first sort property is %s but the inequality filter is on %s", this.query.getOrder(0).getProperty(), ineqProp), IllegalQueryType.FIRST_SORT_NEQ_INEQ_PROP);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatedQuery that = (ValidatedQuery)o;
        return this.query.equals(that.query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    static class IllegalQueryException
    extends ApiProxy.ApplicationException {
        private final IllegalQueryType illegalQueryType;

        IllegalQueryException(String errorDetail, IllegalQueryType illegalQueryType) {
            super(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), errorDetail);
            this.illegalQueryType = illegalQueryType;
        }

        IllegalQueryType getIllegalQueryType() {
            return this.illegalQueryType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum IllegalQueryType {
        KIND_REQUIRED,
        UNSUPPORTED_FILTER,
        FILTER_WITH_MULTIPLE_PROPS,
        MULTIPLE_INEQ_FILTERS,
        FIRST_SORT_NEQ_INEQ_PROP,
        TRANSACTION_REQUIRES_ANCESTOR;

    }
}

