/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.EntityProtoComparators;
import com.google.apphosting.api.DatastorePb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterMatcher {
    public static final FilterMatcher MATCH_ALL = new FilterMatcher(){

        @Override
        public void addFilter(DatastorePb.Query.Filter filter) {
            throw new UnsupportedOperationException("FilterMatcher.MATCH_ALL is immutable");
        }

        @Override
        public boolean matches(List<Comparable<Object>> values) {
            return true;
        }

        @Override
        boolean matchesRange(Comparable<Object> value) {
            return true;
        }
    };
    Comparable<Object> min = NoValue.INSTANCE;
    boolean minInclusive;
    Comparable<Object> max = NoValue.INSTANCE;
    boolean maxInclusive;
    List<Comparable<Object>> equalValues = new ArrayList<Comparable<Object>>();

    FilterMatcher() {
    }

    public boolean considerValueForOrder(Comparable<Object> value) {
        return this.matchesRange(value);
    }

    boolean matchesRange(Comparable<Object> value) {
        int cmp;
        if (this.min != NoValue.INSTANCE && ((cmp = EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(value, this.min)) < 0 || cmp == 0 && !this.minInclusive)) {
            return false;
        }
        return this.max == NoValue.INSTANCE || (cmp = EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(value, this.max)) <= 0 && (cmp != 0 || this.maxInclusive);
    }

    public boolean matches(List<Comparable<Object>> values) {
        Collections.sort(values, EntityProtoComparators.MULTI_TYPE_COMPARATOR);
        for (Comparable<Object> eqValue : this.equalValues) {
            if (Collections.binarySearch(values, eqValue, EntityProtoComparators.MULTI_TYPE_COMPARATOR) >= 0) continue;
            return false;
        }
        for (Comparable<Object> value : values) {
            if (!this.matchesRange(value)) continue;
            return true;
        }
        return false;
    }

    public void addFilter(DatastorePb.Query.Filter filter) {
        Comparable<Object> value = DataTypeTranslator.getComparablePropertyValue(filter.getProperty(0));
        switch (filter.getOpEnum()) {
            case EQUAL: {
                this.equalValues.add(value);
                break;
            }
            case GREATER_THAN: {
                if (this.min != NoValue.INSTANCE && EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(this.min, value) > 0) break;
                this.min = value;
                this.minInclusive = false;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                if (this.min != NoValue.INSTANCE && EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(this.min, value) >= 0) break;
                this.min = value;
                this.minInclusive = true;
                break;
            }
            case LESS_THAN: {
                if (this.max != NoValue.INSTANCE && EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(this.max, value) < 0) break;
                this.max = value;
                this.maxInclusive = false;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                if (this.max != NoValue.INSTANCE && EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(this.max, value) <= 0) break;
                this.max = value;
                this.maxInclusive = true;
                break;
            }
            case EXISTS: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to perform filter using operator " + filter.getOp());
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder("FilterMatcher [");
        if (this.min != NoValue.INSTANCE || this.max != NoValue.INSTANCE) {
            if (this.min != NoValue.INSTANCE) {
                result.append(this.min);
                result.append(this.minInclusive ? " <= " : " < ");
            }
            result.append("X");
            if (this.max != NoValue.INSTANCE) {
                result.append(this.maxInclusive ? " <= " : " < ");
                result.append(this.max);
            }
            if (!this.equalValues.isEmpty()) {
                result.append(" && ");
            }
        }
        if (!this.equalValues.isEmpty()) {
            result.append("X CONTAINS ");
            result.append(this.equalValues);
        }
        result.append("]");
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NoValue
    implements Comparable<Object> {
        static final NoValue INSTANCE = new NoValue();

        private NoValue() {
        }

        @Override
        public int compareTo(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

