/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api;

import com.google.apphosting.api.ApiProxy;
import java.util.Map;
import java.util.regex.Pattern;

public final class NamespaceManager {
    private static final int NAMESPACE_MAX_LENGTH = 100;
    private static final String NAMESPACE_REGEX = "[0-9A-Za-z._-]{0,100}";
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("[0-9A-Za-z._-]{0,100}");
    private static final NamespaceTranslator translator = new DefaultTranslator();
    private static final String CURRENT_NAMESPACE_KEY = NamespaceManager.class.getName() + ".currentNamespace";

    public static void set(String newNamespace) {
        NamespaceManager.validateNamespace(newNamespace);
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        environment.getAttributes().put(CURRENT_NAMESPACE_KEY, newNamespace);
    }

    public static void reset() {
        ApiProxy.getCurrentEnvironment().getAttributes().remove(CURRENT_NAMESPACE_KEY);
    }

    public static String get() {
        Map<String, Object> attributes = ApiProxy.getCurrentEnvironment().getAttributes();
        String namespace = (String)attributes.get(CURRENT_NAMESPACE_KEY);
        if (namespace == null) {
            return "";
        }
        return namespace;
    }

    public static void enableRequestNamespace() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        Map<String, Object> attributes = environment.getAttributes();
        String namespace = (String)attributes.get(CURRENT_NAMESPACE_KEY);
        if (namespace == null) {
            namespace = translator.translate(environment.getRequestNamespace());
            NamespaceManager.validateNamespace(namespace);
            attributes.put(CURRENT_NAMESPACE_KEY, namespace);
        }
    }

    public static void validateNamespace(String namespace) {
        if (!NAMESPACE_PATTERN.matcher(namespace).matches()) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' does not match pattern '" + NAMESPACE_PATTERN + "'.");
        }
    }

    private NamespaceManager() {
    }

    private static class DefaultTranslator
    implements NamespaceTranslator {
        private DefaultTranslator() {
        }

        public String translate(String requestNamespace) {
            return requestNamespace;
        }
    }

    private static interface NamespaceTranslator {
        public String translate(String var1);
    }
}

