/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Equivalence;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public final class EquivalenceWrapper<T> {
    private final Equivalence<? super T> equivalence;
    @Nullable
    private final T reference;

    EquivalenceWrapper(Equivalence<? super T> equivalence, @Nullable T reference) {
        this.equivalence = Preconditions.checkNotNull(equivalence);
        this.reference = reference;
    }

    @Nullable
    public T get() {
        return this.reference;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EquivalenceWrapper) {
            EquivalenceWrapper that = (EquivalenceWrapper)obj;
            Equivalence<T> equivalence = this.equivalence;
            return equivalence.equals(that.equivalence) && equivalence.equivalent(this.reference, that.reference);
        }
        return false;
    }

    public int hashCode() {
        return this.equivalence.hash(this.reference);
    }

    public String toString() {
        return this.equivalence + ".wrap(" + this.reference + ")";
    }
}

