/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import java.util.ArrayList;

public final class TransactionOptions {
    private Boolean multipleEntityGroups;

    private TransactionOptions() {
    }

    TransactionOptions(TransactionOptions original) {
        this.multipleEntityGroups = original.multipleEntityGroups;
    }

    public TransactionOptions multipleEntityGroups(boolean enable) {
        this.multipleEntityGroups = enable;
        return this;
    }

    public TransactionOptions clearMultipleEntityGroups() {
        this.multipleEntityGroups = null;
        return this;
    }

    public Boolean allowsMultipleEntityGroups() {
        return this.multipleEntityGroups;
    }

    public int hashCode() {
        int result = 0;
        if (this.multipleEntityGroups != null) {
            result = result * 31 + (this.multipleEntityGroups != false ? 1 : 0);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TransactionOptions that = (TransactionOptions)obj;
        return !(this.multipleEntityGroups != null ? !this.multipleEntityGroups.equals(that.multipleEntityGroups) : that.multipleEntityGroups != null);
    }

    public String toString() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.multipleEntityGroups != null) {
            result.add("multipleEntityGroups=" + this.multipleEntityGroups);
        }
        return "TransactionOptions" + result;
    }

    public static final class Builder {
        public static TransactionOptions allowMultipleEntityGroups(boolean enable) {
            return Builder.withDefaults().multipleEntityGroups(enable);
        }

        public static TransactionOptions withDefaults() {
            return new TransactionOptions();
        }

        private Builder() {
        }
    }
}

