library(blastula)
library(formattable)

the_data <- read.csv("/workspace/bigquery_results.csv")

if(nrow(the_data) < 1){
  stop("Data only one row, stopping")
}

# Pobieramy przyzwoicie sformatowany łańcuch znaków daty i czasu
date_time <- add_readable_time()
ga4_table <- format_table(the_data)

email <-
  compose_email(
    body = md(glue::glue(
      "Witaj,
      
  zażądałeś swojej historii przeglądania GA4 ze strony internetowej Marka Edmondsona.  Oto ona!
  {ga4_table}
  
")),
footer = md(glue::glue("E-mail został wysłany {date_time}."))
  )

the_email <- Sys.getenv("EMAIL")

if(nzchar(the_email)){
  email %>%
    smtp_send(
      to = the_email,
      from = "me@markedmondson.me",
      subject = "Twoja historia GA4 z blogu Marka Edmondsona",
      credentials = creds_file("/workspace/blastula_gmail_creds")
    )
} else {
  stop("Nie znaleziono e-maila w EMAIL env var")
}


