/**
 * Fukcja transformacji, która odfiltrowuje pola zaczynające się od x-ga
 * @param {string} inJson
 * @return {string} outJson
 */
 function transform(inJson) {
    var obj = JSON.parse(inJson);
    var keys = Object.keys(obj);
    var outJson = {};

    // Nie umieszczamy w danych wyjściowych kluczy z x-ga
    var outJson = keys.filter(function(key) {
        return !key.startsWith('x-ga');
    }).reduce(function(acc, key) {
        acc[key] = obj[key];
        return acc;
    }, {});
    
    return JSON.stringify(outJson);
  }