import numpy as np
np.random.seed(456)
import  tensorflow as tf
tf.set_random_seed(456)
import matplotlib.pyplot as plt
from sklearn.metrics import accuracy_score

# Generowanie danych syntetycznych
N = 100
w_true = 5
b_true = 2
noise_scale = .1
# Zera tworzą rozkład gaussowski wyśrodkowany na (-1, -1)
x_zeros = np.random.multivariate_normal(
    mean=np.array((-1, -1)), cov=.1*np.eye(2), size=(N/2,))
y_zeros = np.zeros((N/2,))
# Jedynki tworzą rozkład gaussowski wyśrodkowany na (1, 1)
x_ones = np.random.multivariate_normal(
    mean=np.array((1, 1)), cov=.1*np.eye(2), size=(N/2,))
y_ones = np.ones((N/2,))

x_np = np.vstack([x_zeros, x_ones])
y_np = np.concatenate([y_zeros, y_ones])


# Zapis obrazu rozkładu danych
plt.xlabel("Wymiar 1")
plt.ylabel("Wymiar 2")
plt.title("Dane klasyfikacyjne FCNet")

# Plot Zeros
plt.scatter(x_zeros[:, 0], x_zeros[:, 1], color="blue")
plt.scatter(x_ones[:, 0], x_ones[:, 1], color="red")
plt.savefig("fcnet_classification_data.png")

# Generowanie wykresu tensorflow
d = 2
n_hidden = 15
with tf.name_scope("wezly_zastepcze"):
  x = tf.placeholder(tf.float32, (N, d))
  y = tf.placeholder(tf.float32, (N,))
with tf.name_scope("warstwa-1"):
  W = tf.Variable(tf.random_normal((d, n_hidden)))
  b = tf.Variable(tf.random_normal((n_hidden,)))
  x_1 = tf.nn.relu(tf.matmul(x, W) + b)
with tf.name_scope("wyjscie"):
  W = tf.Variable(tf.random_normal((n_hidden, 1)))
  b = tf.Variable(tf.random_normal((1,)))
  y_logit = tf.squeeze(tf.matmul(x_1, W) + b)
  # sigmoida podaje klasę prawdopodobieństwa dla 1
  y_one_prob = tf.sigmoid(y_logit)
  # Zaokrąglenie P(y=1) da prawidłową prognozę.
  y_pred = tf.round(y_one_prob)
with tf.name_scope("strata"):
  # Obliczanie entropii krzyżowej dla każdego punktu danych
  entropy = tf.nn.sigmoid_cross_entropy_with_logits(logits=y_logit, labels=y)
  # Sumowanie wszystkich wkładów
  l = tf.reduce_sum(entropy)

with tf.name_scope("optymalizatory"):
  train_op = tf.train.AdamOptimizer(.001).minimize(l)

with tf.name_scope("podsumowania"):
  tf.summary.scalar("strata", l)
  merged = tf.summary.merge_all()

train_writer = tf.summary.FileWriter('/tmp/fcnet-classification-train',
                                     tf.get_default_graph())

n_steps = 200
with tf.Session() as sess:
  sess.run(tf.global_variables_initializer())
  # Trenowanie modelu
  for i in range(n_steps):
    feed_dict = {x: x_np, y: y_np}
    _, summary, loss = sess.run([train_op, merged, l], feed_dict=feed_dict)
    print("krok %d, strata: %f" % (i, loss))
    train_writer.add_summary(summary, i)

  # Tworzenie predykcji
  y_pred_np = sess.run(y_pred, feed_dict={x: x_np})

score = accuracy_score(y_np, y_pred_np)
print("Dokładność klasyfikacji: %f" % score)

