from . import nn

WEIGHTS = [
([[-0.017561763525009155, -0.031003721058368683, 0.020569313317537308, -0.02655755914747715, 0.025539904832839966, 0.022390175610780716, 0.09692873060703278, -0.0014082937268540263, 0.0008421266684308648, 0.009450863115489483, 0.037916459143161774, -0.07492684572935104, -0.07778558135032654, 0.009347543120384216, -0.047730233520269394, -0.1063002422451973, 0.09122911095619202, 0.024024643003940582, -2.771690845489502, -1.0033659934997559, 0.09162099659442902, -0.5170020461082458, -0.22455476224422455, 0.12220380455255508, 0.05308227986097336, 2.4704678058624268, 1.5141726732254028, -0.09368389844894409], [0.015620730817317963, 0.037639837712049484, 0.2940351366996765, 0.13076770305633545, -0.565763533115387, -0.2285969853401184, -0.1709313690662384, 0.03719577565789223, 0.05070621892809868, 0.2857476770877838, -0.005424280650913715, 0.3423558473587036, 0.25172847509384155, -0.010431766510009766, -0.16111548244953156, -0.1841229349374771, 0.3461554944515228, -0.2295159101486206, -1.1965824365615845, 1.1262024641036987, 0.14639969170093536, 0.05705223232507706, 0.22551262378692627, -0.19724853336811066, -0.3961831033229828, 0.894568681716919, -0.12942063808441162, -0.0021186918020248413], [0.04925382509827614, 0.10227890312671661, 0.13003188371658325, 0.10980773717164993, -0.4279971718788147, -0.0029728400986641645, 0.17695553600788116, -0.0002870105381589383, 0.10607525706291199, 0.10530394315719604, 0.11265969276428223, -0.5384754538536072, 0.08446016907691956, 0.10165117681026459, 0.05614296719431877, -0.04840884730219841, -0.05834858864545822, -0.06774450838565826, -1.6266688108444214, 0.4137522876262665, -0.14689160883426666, -0.14055544137954712, -0.12036564201116562, -0.17440900206565857, -0.3035717308521271, 4.3274359703063965, -0.8380805850028992, -0.15869520604610443], [0.4141257703304291, 0.08827358484268188, 0.43830427527427673, 0.2511349022388458, -0.355611652135849, -0.01033808384090662, 0.10139812529087067, 0.1270924061536789, 0.2494860738515854, 0.4276648163795471, 0.2111164778470993, -1.2094268798828125, -0.4873959422111511, 0.03890864551067352, 0.05133403465151787, 0.0628521516919136, 0.36762261390686035, 0.04681854695081711, 1.8066658973693848, -1.0438642501831055, -0.09400004148483276, 0.13338805735111237, 0.4408351182937622, 0.4048948287963867, -0.22741292417049408, -1.5075205564498901, 1.8082809448242188, 0.15494994819164276], [0.4661758840084076, 0.17009705305099487, 0.1234736517071724, 0.20397503674030304, -0.3838431239128113, -0.011279306374490261, -0.08305128663778305, 0.17879746854305267, 0.4553969204425812, 0.30285587906837463, 0.27031731605529785, 0.24740581214427948, -0.629652738571167, 0.13064174354076385, 0.18511039018630981, 0.19943508505821228, 0.10868769884109497, 0.015565997920930386, -0.9971644282341003, -0.7138406038284302, -0.09022752195596695, 0.041709285229444504, -0.21824921667575836, -0.3918761909008026, 0.09919029474258423, 2.299891233444214, 0.5724542140960693, -0.13544678688049316], [0.1907586306333542, 0.07329842448234558, 0.31124040484428406, 0.2651106119155884, -0.2174704223871231, 0.13179902732372284, -0.1640787422657013, 0.0012716766213998199, -0.17192625999450684, 0.2575915455818176, 0.14943429827690125, -0.8720495104789734, 0.12376843392848969, 0.15162591636180878, 0.014488425105810165, -0.04817124456167221, 0.2124365121126175, 0.13031968474388123, -0.9074491262435913, 0.633870542049408, 0.09139148890972137, 0.044988296926021576, -0.558510422706604, 0.07148420065641403, 0.1323397010564804, 1.619550347328186, 0.1696576476097107, 0.15990839898586273], [-0.0547909215092659, 0.009393067099153996, -0.016516566276550293, -0.07593411952257156, -0.10026659816503525, 0.04816437140107155, 0.14767558872699738, 0.0019128117710351944, 0.032242532819509506, -0.02111993171274662, -0.007778090424835682, -0.29846590757369995, 0.19407637417316437, -0.03584784269332886, -0.0018370088655501604, -0.08732175827026367, 0.04217064753174782, 0.04399252310395241, 2.7727696895599365, -1.9461044073104858, 0.03986932337284088, -0.13825589418411255, -0.598426878452301, 0.061191022396087646, 0.16493545472621918, -2.7802734375, 2.230539321899414, -0.061575666069984436], [0.006039703264832497, -0.03522367775440216, -0.005337863694876432, -0.0108095183968544, 0.30988848209381104, 0.13013997673988342, -0.021540388464927673, 0.02366781421005726, -0.0035717301070690155, 0.0034901988692581654, 0.033960167318582535, 0.4735855162143707, 0.058301590383052826, -0.04583042860031128, 0.1421571969985962, -0.07863733917474747, 0.07255470007658005, -0.06291540712118149, -3.6950581073760986, -0.8666949272155762, -0.06429550796747208, 0.291642963886261, 0.016728822141885757, 0.11354507505893707, -0.1388782560825348, 3.14837646484375, -0.35090285539627075, 0.08344654738903046], [0.3128318190574646, -0.07832427322864532, 0.12328992038965225, -0.08712860196828842, 0.6327896118164062, 0.015754036605358124, 0.17391960322856903, 0.3467908203601837, -0.14571741223335266, 0.4408940374851227, 0.31554266810417175, 1.4686554670333862, -0.003918709233403206, 0.030276864767074585, 0.6265019774436951, 0.1955689787864685, 0.5679793953895569, 0.09569438546895981, -1.8028936386108398, 0.43478021025657654, 0.07403115928173065, 0.32345470786094666, -0.03801082819700241, 0.3658160865306854, -0.07695768028497696, -0.4174349904060364, -1.2718956470489502, -0.0977209284901619], [-0.1731628030538559, -0.04760025814175606, 0.1210072785615921, 0.2164289355278015, 0.19809523224830627, 0.06429917365312576, -0.1697004735469818, -0.22180669009685516, -0.22348837554454803, 0.1417894959449768, 0.07047443836927414, -0.527880847454071, 0.1966600865125656, 0.17016522586345673, -0.1405465304851532, -0.0054641226306557655, 0.048048052936792374, 0.13248863816261292, -1.182335376739502, -1.0058622360229492, 0.1583196073770523, 0.17926858365535736, 0.6554962396621704, 0.6660558581352234, -0.02660094015300274, -1.3004971742630005, 1.3819904327392578, -0.1441652476787567], [-0.08406920731067657, 0.033040132373571396, -0.013186576776206493, 0.005887831561267376, 0.23534981906414032, 0.26640522480010986, 0.06119902431964874, 0.02190171740949154, 0.0788731575012207, -0.006268512923270464, 0.044986799359321594, -0.18022464215755463, 0.3362690508365631, -0.10230050981044769, 0.006018602754920721, -0.08799836039543152, 0.028993425890803337, -0.08633308112621307, 1.5248504877090454, 0.7636837959289551, -0.16325020790100098, 0.18428857624530792, 0.007751022931188345, -0.12727311253547668, -1.09554123878479, -0.7189103364944458, 0.16454702615737915, -0.04442209005355835], [-1.0207725763320923, -0.5438963770866394, -0.3853072226047516, -0.634120762348175, 0.09743677824735641, 0.16281309723854065, -0.12043869495391846, -1.3888102769851685, -0.7301799058914185, -0.9657494425773621, -0.34710684418678284, 0.4822025001049042, 0.40042516589164734, 0.04197680950164795, -1.540086030960083, -0.4415806233882904, -0.7551231980323792, 0.390516459941864, 0.8612852096557617, -0.07134025543928146, 0.01406027376651764, -0.11968663334846497, -1.254460096359253, -0.30991923809051514, -1.5243253707885742, 0.14085829257965088, -2.374436378479004, 0.0020212531089782715], [0.13473230600357056, 0.10718952119350433, 0.15379475057125092, 0.16498862206935883, 0.17538410425186157, -0.26279500126838684, -0.017926335334777832, 0.04345903918147087, 0.2662934362888336, 0.11377327889204025, -0.004987021908164024, 0.21223184466362, -0.21190860867500305, 0.1267051249742508, 0.08962056785821915, 0.08497790992259979, 0.19404755532741547, -0.0848393589258194, -1.6874449253082275, 1.100673794746399, 0.14624853432178497, -0.002704379614442587, -0.29424548149108887, 0.35988688468933105, -0.2622247636318207, 0.4631669223308563, -1.2120161056518555, 0.0820094496011734], [-0.6994959712028503, -0.4533250033855438, -0.6636907458305359, 0.08925779908895493, -0.5095456838607788, 0.933526873588562, -0.1379036009311676, -1.5582685470581055, -0.3660934865474701, -0.9553481340408325, -0.2665538787841797, -1.0216927528381348, 1.0916502475738525, -0.04626785218715668, -1.47275972366333, -0.5926599502563477, -0.7516128420829773, -0.3256944417953491, -1.3211352825164795, 1.8266218900680542, 0.13990186154842377, -1.0863735675811768, -0.8331276774406433, -0.7025905847549438, 0.28823521733283997, -0.6375077366828918, 3.0743567943573, -0.03988504409790039], [0.4040069878101349, 0.4084564745426178, 0.3336328864097595, 0.20373667776584625, -0.35536354780197144, -0.22264055907726288, 0.12639667093753815, 0.26560768485069275, 0.10732170939445496, 0.47441717982292175, 0.21570198237895966, -0.34895434975624084, 0.05522521585226059, 0.15499471127986908, 0.2465038001537323, 0.01083713211119175, 0.39845919609069824, 0.10817676037549973, 0.9060823917388916, 0.18782255053520203, -0.08452681452035904, 0.24966993927955627, 0.21928134560585022, 0.1616487354040146, 0.38026702404022217, -3.155186653137207, 0.813122570514679, -0.13810086250305176], [-0.10387127101421356, 0.14017713069915771, -0.04909316822886467, -0.19227640330791473, -0.32803598046302795, -0.03218181058764458, -0.09302334487438202, -0.024699710309505463, 0.06947695463895798, -0.05323885753750801, 0.07632142305374146, -0.7189206480979919, 0.07738807797431946, 0.08909730613231659, 0.20159612596035004, 0.0406421422958374, -0.18919281661510468, -0.025657175108790398, -1.4766000509262085, 0.09085554629564285, -0.07445112615823746, 0.1537955403327942, -0.05807522311806679, 0.04296896979212761, -0.29371100664138794, 2.755723714828491, -0.6646450757980347, 0.010684341192245483], [0.20053060352802277, 0.020308541133999825, 0.20680783689022064, 0.13956308364868164, 0.7214125394821167, 0.003942461684346199, 0.14373637735843658, 0.10247502475976944, -0.15451650321483612, -0.040152955800294876, -0.09011682868003845, 0.9583864212036133, 0.2501866817474365, 0.0035216212272644043, 0.4116251468658447, -0.02418099343776703, 0.26703765988349915, 0.2843847870826721, -1.8349472284317017, 0.16081306338310242, -0.17424505949020386, 0.3449816107749939, 0.18300610780715942, 0.6149440407752991, -0.06234242767095566, -0.38144585490226746, -0.32636722922325134, -0.028325751423835754], [-0.004450069274753332, 0.02366502955555916, 0.02800663374364376, -0.007743611000478268, 0.1166938915848732, 0.0018805189756676555, -0.04894232749938965, -0.029107363894581795, 0.014448683708906174, -0.034016285091638565, 0.024137426167726517, 0.14681200683116913, 0.0964810773730278, 0.176009401679039, 0.07543818652629852, -0.07710597664117813, 0.04099521413445473, -0.041232604533433914, -3.3675217628479004, 0.755443811416626, 0.0795893520116806, 0.08437668532133102, -0.9789732098579407, 0.07796259969472885, -0.14738312363624573, 3.663841724395752, -1.1558761596679688, 0.11146597564220428], [0.052300263196229935, 0.007274013943970203, 0.004366686567664146, 0.010742733255028725, -0.5081835985183716, 0.1484612375497818, 0.15013064444065094, 0.04242692515254021, 0.029113415628671646, 0.03851800039410591, -0.014305303804576397, -0.042110543698072433, -0.3395182490348816, 0.005438029766082764, -0.09892205893993378, 0.028808191418647766, -0.28478968143463135, -0.01002759113907814, 3.578521490097046, 0.7835169434547424, -0.17744247615337372, 0.04398166388273239, 0.2252049744129181, -0.033552467823028564, 0.34587743878364563, -4.287456035614014, -1.72658109664917, -0.1104513630270958], [-0.02980775386095047, -0.021209755912423134, -0.005362858064472675, 0.070872463285923, -0.1114950105547905, 0.2876853346824646, 0.015341416001319885, -0.046146515756845474, 0.03387365862727165, 0.0005745032103732228, 0.09909068048000336, 0.013776436448097229, 0.05052540451288223, -0.0931917205452919, 0.005107236094772816, 0.08183828741312027, -0.013890016824007034, 0.03591950982809067, 1.4233622550964355, -0.5821260809898376, 0.0920024961233139, 0.25158748030662537, -0.008674047887325287, -0.021119335666298866, -0.41244369745254517, 1.8950375318527222, 2.6191248893737793, 0.10365895926952362]], [[0.3288595676422119, 0.7200850248336792, 0.9560680985450745, 0.15488150715827942, -0.13159795105457306, 0.7959101796150208, 0.11972345411777496, -0.18049085140228271, -0.0954458937048912, 0.10003375262022018, 0.7325778007507324, 0.48999401926994324, 0.06588539481163025, -0.8808764815330505, -0.3000515103340149, 1.0637787580490112, -0.07564176619052887, 0.5693174004554749, -0.48792561888694763, 0.02688766084611416]]),
([[1.5926381349563599, -0.03608933091163635, 1.7135330438613892, -0.5189054608345032, 0.154734268784523, -0.316354364156723, 0.06573636829853058, -1.9859358072280884, 0.47833600640296936, 0.12969066202640533, -0.03485303372144699, -0.9834554195404053, 0.2766335606575012, -0.8989982604980469, -0.4249456524848938, -0.050042204558849335, 0.47881200909614563, -0.891993522644043, 1.6704906225204468, -0.6537483930587769], [-0.022679327055811882, 0.05453302338719368, -0.6899846792221069, -0.2970145344734192, 0.12546579539775848, 1.0300095081329346, 7.00372314453125, 0.2108011096715927, 0.053451575338840485, -0.22382816672325134, 0.08739816397428513, 1.3667747974395752, 0.8137140870094299, -2.8630073070526123, -0.4394129514694214, 0.771719217300415, -0.11192753911018372, -1.5026144981384277, -0.9025478363037109, -0.1900574415922165], [-0.08405002951622009, 0.834780752658844, -0.8636256456375122, -0.6702651381492615, 0.9380892515182495, 0.3222295045852661, 0.07687166333198547, -0.6368979215621948, 0.07808218151330948, 0.27443671226501465, -0.09361512959003448, 1.2641916275024414, -0.10405416041612625, -2.7929954528808594, -0.3948536217212677, 0.4995095431804657, 0.17783325910568237, -0.31724533438682556, -3.9671199321746826, 0.07780968397855759], [0.0677521601319313, -0.21228374540805817, -0.5642512440681458, 0.2443065345287323, 0.4525734782218933, 0.3198515772819519, 0.0800643041729927, -0.8796993494033813, -0.07799844443798065, 0.2771097719669342, 1.1968104839324951, -0.7625207304954529, -0.40774741768836975, -3.9699721336364746, -0.2838728725910187, 0.14194053411483765, 0.076247438788414, 0.08960981667041779, 0.37074655294418335, -1.153111219406128]], [[-0.36507123708724976, 0.14604559540748596, 0.30798110365867615, 0.17501340806484222]]),
]


def forward(x):
    x = nn.linear(x, WEIGHTS[0])
    x = nn.relu(x)
    x = nn.linear(x, WEIGHTS[1])
    x = nn.tanh(x)
    return x


def test():
    x = [[0.0]] * 28
    y = forward(x)
    print(y)
    
    
def show():
    for idx, (w, b) in enumerate(WEIGHTS):
        print("Layer %d:" % (idx+1))
        print("W: (%d, %d), B: (%d, %d)" % (len(w), len(w[0]), len(b), len(b[0])))

