"""Aplikacja odpowiadająca na pytania napisana przy pomocy Streamlit.

Na podstawie tego szablonu:
https://github.com/hwchase17/langchain-streamlit-template/blob/master/main.py

Uruchom lokalnie w ten sposób:
> PYTHONPATH=. streamlit run question_answering/app.py

Możesz też wdrożyć na platformie Streamlit Community Cloud
lub Hugging Face Spaces. For Streamlit Community Cloud. W tym celu:
1. Utwórz repozytorium na GitHubie
2. Idź do Streamlit Community Cloud, naciśnij "New app" i wybierz utworzone przed chwilą repozytorium
3. Naciśnij "Deploy!"
"""
import streamlit as st
from langchain.callbacks import StreamlitCallbackHandler

from question_answering.utils import MEMORY
from question_answering.agent import load_agent

st.set_page_config(page_title="LangChain: Odpowiadanie na pytania", page_icon=":robot:")
st.header("Zadaj pytanie!")

strategy = st.radio(
    "Strategia rozumowania",
    ("plan-and-solve", "zero-shot-react", ))

tool_names = st.multiselect(
    'Jakich narzędzi chcesz użyć?',
    [
        "google-search", "ddg-search", "wolfram-alpha", "arxiv",
        "wikipedia", "python_repl", "pal-math",
        "llm-math"
    ],
    ["ddg-search", "wolfram-alpha", "wikipedia"])
if st.sidebar.button("Wyczyść historię konwersacji"):
    MEMORY.chat_memory.clear()

avatars = {"human": "user", "ai": "assistant"}
for msg in MEMORY.chat_memory.messages:
    st.chat_message(avatars[msg.type]).write(msg.content)

assert strategy is not None
agent_chain = load_agent(tool_names=tool_names, strategy=strategy)

assistant = st.chat_message("assistant")
if prompt := st.chat_input(placeholder="Zapytaj mnie o cokolwiek!"):
    st.chat_message("user").write(prompt)
    stream_handler = StreamlitCallbackHandler(assistant)
    with st.chat_message("assistant"):
        response = agent_chain.run({
            "input": prompt,
            "chat_history": MEMORY.chat_memory.messages
        }, callbacks=[stream_handler]
        )
