from langchain import PromptTemplate, LLMChain
from langchain.chains import SequentialChain
from langchain.chat_models import ChatOpenAI

from config import set_environment

set_environment()

solutions_template = """
Wygeneruj {num_solutions} różnych odpowiedzi na to pytanie:
{question}

Solutions:
"""
solutions_prompt = PromptTemplate(
   template=solutions_template,
   input_variables=["question", "num_solutions"]
)
solutions_chain = LLMChain(
   llm=ChatOpenAI(),
   prompt=solutions_prompt,
   output_key="solutions"
)

consistency_template = """
Dla każdehj odpowiedzi z {solutions} policz, jak często występowała. Na końcu wybierz odpowiedź, która występuje najczęściej.

Najczęstesze rozwiązanie: 
"""
consistency_prompt = PromptTemplate(
   template=consistency_template,
   input_variables=["solutions"]
)
consistency_chain = LLMChain(
   llm=ChatOpenAI(),
   prompt=consistency_prompt,
   output_key="best_solution"
)
answer_chain = SequentialChain(
   chains=[solutions_chain, consistency_chain],
   input_variables=["question", "num_solutions"],
   output_variables=["best_solution"]
)

print(answer_chain.run(
   question="Kiedy została podpisana Deklaracja niepodległości Stanów Zjednoczonych?",
   num_solutions="5"
))


if __name__ == "__main__":
    pass
