from langchain import PromptTemplate, FewShotPromptTemplate
from langchain.embeddings import OpenAIEmbeddings
from langchain.prompts.example_selector import SemanticSimilarityExampleSelector
from langchain.chat_models import ChatOpenAI
from langchain.vectorstores import Chroma

from config import set_environment

set_environment()

model = ChatOpenAI()

example_prompt = PromptTemplate(
    template="{input} -> {output}",
    input_variables=["input", "output"],
)
examples = [{
    "input": "Kocham tę aktualizację. Wszystko działa bez zarzutu",
    "output": "Pozytywny",
    },{
    "input": "Jest OK, ale mógłby używać więcej funkcji.",
    "output": "Neutralny",
    }, {
    "input": "Jestem rozczarowany usługą, oczekiwałem lepszego działania.",
    "output": "Negatywny"
}]

prompt = FewShotPromptTemplate(
    examples=examples,
    example_prompt=example_prompt,
    suffix="Question: {input}",
    input_variables=["input"]
)
print((prompt | model).invoke({"input": "To świetna książka z dobrymi przykładami."}))

selector = SemanticSimilarityExampleSelector.from_examples(
    examples=examples,
    embeddings=OpenAIEmbeddings(),
    vectorstore_cls=Chroma,
    k=4,
)
prompt = FewShotPromptTemplate(
    example_selector=selector,
    example_prompt=example_prompt,
    suffix="Question: {input}",
    input_variables=["input"]
)
print((prompt | model).invoke({"input": "Ile jest 10+10?"}))


if __name__ == "__main__":
    pass
