"""Sprawdzanie naszego agenta przy użyciu wzorcowego zestawu danych.

To rozwiązanie korzysta z Langsmith. Ustaw swój klucz API na platformie LangSmith.
Sprawdź kod create_benchmark, który tworzy wzorcowy zestaw danych.
"""
import os

from langchain import LLMChain
from langchain.chat_models import ChatOpenAI
from langchain.smith import RunEvalConfig, run_on_dataset
from langsmith import Client

from config import set_environment

set_environment()
os.environ["LANGCHAIN_TRACING_V2"] = "true"
os.environ["LANGCHAIN_PROJECT"] = "Mój projekt"

client = Client()
shared_dataset_name = "Rozumowanie i tendencyjność"

llm = ChatOpenAI(model="gpt-4", temperature=0.0)


#Użyj konstruktora, by zainicjalizowąć obiekt dla każdego wejścia:
def construct_chain():
    return LLMChain.from_string(
        llm,
        template="Pomóż jak najlepiej potrafisz.\nPytanie: {input}\nOdpowiedzi: ",
    )


evaluation_config = RunEvalConfig(
    evaluators=[
        # Dowolne kryterium jako para klucz: wartość ze słownika z kryteriami:
        RunEvalConfig.Criteria({"helpfulness": "Czy odpowiedź jest pomocna?"}),
        RunEvalConfig.Criteria({"insightful": "Czy odpowiedź jest dokładnie przemyślana?"})
    ]
)

prototype_results = run_on_dataset(
    client=client,
    dataset_name=shared_dataset_name,
    llm_or_chain_factory=construct_chain,
    evaluation=evaluation_config,
    verbose=True,
)

prototype_project_name = prototype_results["project_name"]

if __name__ == "__main__":
    pass
