"""Asystent pisania.

Uruchom w ten sposób:
>> gradio writing_assistant/app.py."""
import gradio as gr
from langchain.chat_models import ChatOpenAI
from langchain.schema import SystemMessage, HumanMessage

from config import set_environment


set_environment()

LLM = ChatOpenAI(
    model_name="gpt-4",
    temperature=0.,
)
MISSION = "Jesteś pomocnym asystentem, który potrafi poprawiać i ulepszać teksty pod kątem" \
          " stylu, interpunkcji, gramatyki, słownictwa i ortografii," \
          " aby wyglądały jak napisane przez native speakera."

PREFIX = "Podaj informacje zwrotne na temat błędnej pisowni, gramatyki i wyrażeń w tekście" \
         " poniżej. Sprawdź spójność czasów. Wyjaśnij zasady gramatyczne i podaj przykłady" \
         " tych zasad. Daj wskazówki, aby tekst był bardziej zwięzły i interesujący."
         
         "Tekst: {text}." \
         "" \
         "Informacja zwrotna: "


def suggest_improvements(input: str, temperature: float) -> str:
    """Zaproponuj poprawki tekstu."""
    messages = [
        SystemMessage(
            content=MISSION
        ),
        HumanMessage(
            content=PREFIX.format(text=input)
        ),
    ]
    output = LLM(messages, temperature=temperature).content
    return output


demo = gr.Interface(
    fn=suggest_improvements,
    inputs=["text", gr.Slider(0., 1.0, label="Temperaturea")],
    outputs=["text"],
)
with demo:
    gr.HTML(
        "<center>Zasilane przez <a href='https://github.com/langchain_ai/langchain'>LangChain 🦜️🔗</a></center>"
    )

demo.launch()
