"""Agent planujący i wytwrzający oprogramowanie."""

from langchain import LLMChain, OpenAI, PromptTemplate
from langchain.agents import Tool
from langchain.tools import DuckDuckGoSearchResults, BaseTool
from langchain_experimental.plan_and_execute import (
    PlanAndExecute,
    load_agent_executor,
    load_chat_planner,
)

from config import set_environment
from software_development.python_developer import DEV_PROMPT, PythonDeveloper, PythonExecutorInput

set_environment()

todo_prompt = PromptTemplate.from_template(
    "Jesteś ekspertem planowania i potrafisz przygotować wymagania, "
    "funkcje dla danego zadania. "
    "Używaj tego, gdy musisz rozbić zadanie na mniejsze zadania."
    "Lista wynikowa powinna mieć taką formę {nazwa funkcji}: {wymagania dla funkcji}"
    "Przygotuj listę niezbędnych funkcji dla tego celu: {objective}"
)
todo_llm = LLMChain(
    llm=OpenAI(temperature=0, model_name='gpt-3.5-turbo-instruct'),
    prompt=todo_prompt
)
# # , model_name="ada"
software_prompt = PromptTemplate.from_template(DEV_PROMPT)
# ostrożnie: jeśli masz złą specyfikację modelu, możesz nie uzyskać żadnego kodu!
software_llm = LLMChain(
    llm=OpenAI(
        temperature=0,
        max_tokens=4000
    ),
    prompt=software_prompt
)
software_dev = PythonDeveloper(llm_chain=software_llm)

code_tool = Tool(
    name="PythonSoftwareEngineer",
    func=software_dev.run,
    description=(
        "Przydatne do wyszukiwania i zrozumienia podłoża i celów."
        "Wejście: cel."
        "Wyjście: Informacje dotyczące celu."
    ),
    args_schema=PythonExecutorInput
)
planner_tool = Tool(
    name="TODO",
    func=todo_llm.run,
    description=(
        "Przydatne, jeśli musisz przygotować wymagania."
        "Wejście: cel, dla którego trzeba przygotować listę zadań do wykonania. "
        "Wyjście: lista zadań do wykonania dla celu . "
        "Bardzo jasno sprecyzuj cel!"
    )
)
ddg_search = DuckDuckGoSearchResults()
tools: list[BaseTool] = [
    code_tool,
    Tool(
        name="DDGSearch",
        func=ddg_search.run,
        description=(
            "Przydatne do wyszukiwania i zrozumienia podłoża i celów."
            "Wejście: cel."
            "Wyjście: informacje dotyczące celu."
        )
    )
]

PREFIX = """Jesteś agentem zaprojektowanym do pisania kodu w języku Python.

Historia czatu:
{chat_history}

Masz dostęp do środowiska REPL Pythona, w którym możesz wykonać kod. 
Twoje zadanie kończy się po napisaniu i sprawdzeniu kodu pod kątem błędów.
Jeśli nie jesteś w stanie napisać tego kodu, w odpowiedzi zwróć informację "Mam problem zaimplementowaniem tego zadania".
"""
SUFFIX = """Zacznij! Twoim celem jest napisanie programu. Jeśli w kodzie jest błąd, usuń go i spróbuj jeszcze raz!"

Zadanie: {input}
{agent_scratchpad}

"""

# memory = ConversationBufferMemory(memory_key="chat_history", return_messages=True)
# prompt = ZeroShotAgent.create_prompt(
#     tools, prefix=PREFIX,
#     suffix=SUFFIX, input_variables=["input", "agent_scratchpad", "chat_history"]
# )

llm = OpenAI(model_name='gpt-3.5-turbo-instruct')
planner = load_chat_planner(llm)
executor = load_agent_executor(
    llm,
    tools,
    verbose=True,
)
agent_executor = PlanAndExecute(
    planner=planner,
    executor=executor,
    verbose=True,
    handle_parsing_errors="Sprawdź wynik i upewnij się, że jest zgodny z wymaganiami!",
    return_intermediate_steps=True
)

# agent = ZeroShotAgent(
#     llm_chain=llm_chain,
#     allowed_tools=tool_names,
#     handle_parsing_errors="Check your output and make sure it conforms!",
# )
# agent_executor = AgentExecutor.from_agent_and_tools(
#     agent=agent, tools=tools, verbose=True
# )


# # Logging of LLMChains
# verbose = False
# # If None, it will never stop
# max_iterations = 3
# baby_agi = BabyAGI.from_llm(
#     llm=llm, vectorstore=vectorstore, verbose=verbose, max_iterations=max_iterations
# )

# agent_executor = create_python_agent(
#     llm=OpenAI(temperature=0, max_tokens=1000),
#     tool=code_excution,
#     verbose=True,
#     agent_type=AgentType.ZERO_SHOT_REACT_DESCRIPTION,
# )


if __name__ == "__main__":
    agent_executor.run("Napisz grę Tetris w języku Python!")
