"""Monity dla streszczeń.

za https://github.com/daveshap/Quickly_Extract_Science_Papers
"""

# Łańcuch gęstości
DENSITY_PROMPT = """
Artykuł: {text}

---
Wytyczne dotyczące streszczania dokumentu
Będziesz tworzyć coraz bardziej zwięzłe, pełne informacji streszczenia powyższego artykułu. Powtórz poniższe 2 kroki 5 razy.

Powtórz następujące 2 kroki 5 razy:
Krok 1: Zidentyfikuj 1-3 informacyjne jednostki (oddzielone ";") z poprzedniej wygenerowanej wersji podsumowania. 
Krok 2: Napisz nowe, bardziej zwięzłe podsumowanie, które obejmuje każdą wymienioną jednostkę, plus brakujące jednostki.

Brakujący element to:
- Istotny: dla głównej fabuły.
- Konkretny: opisowy, ale zwięzły (5 słów lub mniej).
- Nowatorski: nieobecny w poprzednim streszczeniu.
- Wierny: obecny w artykule.
- Gdziekolwiek: znajdujący się w dowolnym miejscu artykułu.

Wytyczne:
- Każde słowo ma znaczenie!
- Stwórz przestrzeń poprzez fuzję, kompresję i usuwanie nieinformacyjnych fraz.
- Podsumowania powinny być bardzo zwięzłe i zwarte, ale samowystarczalne.
- Brakujące jednostki mogą pojawić się w dowolnym miejscu nowego podsumowania.
- Nigdy nie pomijaj jednostek z poprzedniego podsumowania. Jeśli nie można zrobić miejsca, dodaj mniej nowych jednostek.t

Odpowiedz w formacie JSON. JSON powinien być listą (długość 5) słowników

"""

SUMMARY = (
    "Streść ten tekst w możliwie najdrobniejszych szczegółach. Podaj jasne wyjaśnienie celów, głównych twierdzeń, implikacji"
    "oraz mechanizmów wyjaśnionych w tym tekście - usuń cytaty! \n"
    "Chcę podkreślić najważniejsze punkty, zaczynając od ich ważności i wpływu, mechanizmów, dostępnych narzędzi oraz potencjalnych rozszerzeń wpływających na takie aspekty jak prywatność, bezpieczeństwo, elastyczność, konkurencyjność, łatwość użycia."

    "Tekst: {text} \n"
)

HIGH_LEVEL = (
    "Proszę wyjaśnić wartość tego tekstu prostymi słowami, jakbyś rozmawiał z CEO." 
    "Jaki jest tego sens ? Co jest tutaj najważniejsze?\n"
    "{text}\n"
)

ANALOGY = (
    "Proszę podać analogię lub metaforę, która pomoże wyjaśnić ten tekst  "
    "szerokiej publiczności!!\n"
    "{text}\n"
)
