const parseAppID = 'IDENTYFIKATOR_APLIKACJI'
const parseRestKey = 'KLUCZ_GŁÓWNY'
const apiBase = `http://localhost:1337/parse`

$(document).ready(function() {  
  Parse.initialize(parseAppID, parseRestKey)
  Parse.serverURL = 'http://localhost:1337/parse'

  const Test = Parse.Object.extend('Test')
  const test = new Test()
  const query = new Parse.Query(Test)

  $('.btn-save').click(function(){
    let data
    try {
       data = JSON.parse($('textarea').val())
    } catch (e) {
      alert('Nieprawidłowe dane JSON.')
    }
    if (!data) return false
    test.save(data, {
    success: (result) => {
      console.log('Obiekt Parse.com został zapisany: ', result)
      $('.log').html(JSON.stringify(result, null, 2))
    },
    error: (error) => {
      console.log(`Błąd! Obiekt Parse.com nie został zapisany: ${error}`)
    }
    })
  })

  $('.btn-get').click(function(){
    query.find({
      success: function(results) {
        $('.log').html(JSON.stringify(results, null, 2))
      },
      error: function(error) {
        alert(`Błąd: ${error.code} ${error.message}`)
      }
    })
  })
})
function getMessages() {
  $.ajax({
    url: `${apiBase}/classes/MessageBoard?limit=1000`,
    headers: {
      'X-Parse-Application-Id': parseAppID,
      'X-Parse-REST-API-Key': parseRestKey
    },
    contentType: 'application/json',
    dataType: 'json',
    type: 'GET',
    success: (data) => {
      console.log('Pobrano!')
      updateView(data)
    },
    error: () => {
      console.log('Błąd!')
    }
  })
}
function updateView(messages) {
  // messages.results = messages.results.reverse()
  const table = $('.table tbody')
  table.html(``)
  $.each(messages.results, (index, value) => {
    const trEl = (`<tr><td>
      ${value.username}
      </td><td>
      ${value.message}
      </td></tr>`)
    table.append(trEl)
  })
  console.log(messages)
}
