const http = require('http')
// Wczytanie modułu http.
const util= require('util')
// Uzyskanie dostępu do użytecznych funkcji.
const querystring = require('querystring')
// Wczytanie modułu querystring potrzebnego do przeprowadzenia serializacji
// i deserializacji obiektów oraz ciągów tekstowych zapytania.
const port = process.env.PORT || 1337

const messages=[]
// To jest tablica do przechowywania wiadomości.
messages.push({
  'name': 'Jan',
  'message': 'cześć'
})
// Przykładowa metoda do testowania listy.
exports.server=http.createServer(function (req, res) {
// Utworzenie serwera
    if (req.method == 'POST' && req.url == '/messages/create.json') {
    // Jeżeli metoda HTTP to POST, a adres URL to /messages/, wiadomość należy dodać do tablicy.
    let message = "
    req.on('Dane', function(data, msg) {
      console.log(data.toString('utf-8'))
      message=exports.addMessage(data.toString('utf-8'))
      // Dane są typu Buffer i najpierw muszą zostać skonwertowane na postać ciągu tekstowego UTF-8.
      // Dodawanie wiadomości do tablicy.
    })
    req.on('end', function() {
      console.log('Wiadomość', util.inspect(message, true, null))
      console.log('Wiadomości:', util.inspect(messages, true, null))
      // Wyświetlenie w terminalu danych wyjściowych procesu debugowania.
      res.writeHead(200, {'Content-Type': 'text/plain'})
      // Zdefiniowanie odpowiedniego nagłówka i kodu stanu.
      res.end(message)
      // Dane wyjściowe to wiadomość, powinny zawierać identyfikator obiektu.
    })
  } else
  if (req.method == 'GET' && req.url == '/messages/list.json') {
    // Jeżeli metoda HTTP to GET, a adres URL to /messages, należy wyświetlić listę wiadomości.
    const body = exports.getMessages()
    // Zmienna body będzie zawierała dane wyjściowe.
    res.writeHead(200, {
      'Content-Length': body.length,
      'Content-Type': 'text/plain'
    })
    res.end(body)
  } else {
    res.writeHead(200, {'Content-Type': 'text/plain'})
    // Zdefiniowanie odpowiedniego nagłówka i kodu stanu.
    res.end('Witaj, świecie!\n')
    // Dane wyjściowe to ciąg tekstowy ze znakiem nowego wiersza.
  }

}).listen(port)
// Przypisanie adresu IP i numeru portu serwera.
console.log('Serwer jest dostępny pod adresem http://127.0.0.1:%s/', port)

exports.getMessages = function() {
  return JSON.stringify(messages)
  // Dane wyjściowe to tablica wiadomości w formacie ciągu tekstowego.
}
exports.addMessage = function (data) {
  messages.push(querystring.parse(data))
  // Aby przeprowadzić konwersję na obiekt JavaScriptu, należy użyć analizatora składni i deserializacji.
  return JSON.stringify(querystring.parse(data))
  // Wygenerowana nowa wiadomość w formacie JSON w postaci ciągu tekstowego.
}
